/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer;

import com.atlassian.jira.plugins.importer.external.beans.NamedExternalObject;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SqlUtils {
    private static final Logger log = Logger.getLogger(SqlUtils.class);
    public static final String META_COLUMN_NAME = "COLUMN_NAME";

    public static void close(PreparedStatement ps, ResultSet rs) {
        SqlUtils.close(ps);
        SqlUtils.close(rs);
    }

    public static void close(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String getSQLTokens(String[] names) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            sb.append(" ? ");
            if (i == names.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getColumnNames(Connection connection, String tableName) throws SQLException {
        ResultSet rs = connection.getMetaData().getColumns(null, null, tableName, null);
        try {
            ArrayList columns = Lists.newArrayList();
            while (rs.next()) {
                columns.add(rs.getString(META_COLUMN_NAME));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Columns in taable [ " + tableName + " ]: " + Joiner.on((String)", ").join((Iterable)columns)));
            }
            ArrayList arrayList = columns;
            return arrayList;
        }
        finally {
            SqlUtils.close(rs);
        }
    }

    public static List<String> getColumnNames(ResultSetMetaData metaData) throws SQLException {
        ArrayList set = Lists.newArrayList();
        int s = metaData.getColumnCount();
        for (int i = 1; i <= s; ++i) {
            set.add(metaData.getColumnName(i));
        }
        return set;
    }

    public static String or(Collection<? extends NamedExternalObject> objs) {
        return StringUtils.join(Iterables.transform(objs, (Function)NamedExternalObject.ID_FUNCTION).iterator(), (String)" OR ");
    }

    public static String comma(Collection<? extends NamedExternalObject> objs) {
        return StringUtils.join(Iterables.transform(objs, (Function)NamedExternalObject.ID_FUNCTION).iterator(), (String)",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTable(@Nonnull Connection connection, @Nonnull String tableName) throws SQLException {
        try (ResultSet columns = connection.getMetaData().getTables(null, null, tableName, null);){
            if (columns.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

