/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.passwordpolicy.config;

import com.atlassian.analytics.api.annotations.Analytics;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugins.passwordpolicy.config.PasswordPolicyConfiguration;
import com.atlassian.jira.plugins.passwordpolicy.config.PasswordPolicyConfigurationLoader;
import com.atlassian.jira.plugins.passwordpolicy.config.SimilarityCheck;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.util.concurrent.ResettableLazyReference;

public class PasswordPolicyConfigurationLoaderImpl
implements PasswordPolicyConfigurationLoader {
    private final EventPublisher eventPublisher;
    private final ResettableLazyReference<PluginSettings> settings;

    public PasswordPolicyConfigurationLoaderImpl(final PluginSettingsFactory pluginSettingsFactory, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.settings = new ResettableLazyReference<PluginSettings>(){

            protected PluginSettings create() throws Exception {
                return pluginSettingsFactory.createGlobalSettings();
            }
        };
    }

    @Override
    public PasswordPolicyConfiguration load() {
        return new PasswordPolicyConfiguration((PluginSettings)this.settings.get());
    }

    @Override
    public void store(PasswordPolicyConfiguration config) {
        config.writeTo((PluginSettings)this.settings.get());
        this.eventPublisher.publish((Object)new PasswordPolicyConfigurationUpdated(config));
    }

    @Override
    public void reset() {
        this.settings.reset();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.reset();
    }

    @Analytics(value="passwordpolicy.updated")
    public static class PasswordPolicyConfigurationUpdated {
        final PasswordPolicyConfiguration config;

        PasswordPolicyConfigurationUpdated(PasswordPolicyConfiguration config) {
            this.config = (PasswordPolicyConfiguration)Assertions.notNull((String)"config", (Object)config);
        }

        public String getPasswordPolicyMode() {
            return this.config.getPasswordPolicyMode().toString();
        }

        public int getMinimumLength() {
            return this.config.getMinimumLength();
        }

        public int getMaximumLength() {
            return this.config.getMaximumLength();
        }

        public int getMinimumLowercase() {
            return this.config.getMinimumLowercase();
        }

        public int getMinimumUppercase() {
            return this.config.getMinimumUppercase();
        }

        public int getMinimumDigits() {
            return this.config.getMinimumDigits();
        }

        public int getMinimumSpecial() {
            return this.config.getMinimumSpecial();
        }

        public int getMinimumDistinctCharacterClasses() {
            return this.config.getMinimumDistinctCharacterClasses();
        }

        public boolean getEnablePassphraseExemption() {
            return this.config.getEnablePassphraseExemption();
        }

        public SimilarityCheck getSimilarityToUserInfo() {
            return this.config.getSimilarityToUserInfo();
        }

        public SimilarityCheck getSimilarityToOldPassword() {
            return this.config.getSimilarityToOldPassword();
        }

        public String toString() {
            return "PasswordPolicyConfigurationChanged[" + this.config + ']';
        }
    }
}

