/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.passwordpolicy.conditions;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.annotation.Nullable;

public class CanChangePasswordsCondition
implements Condition {
    private final CrowdDirectoryService crowdDirectoryService;
    private final ApplicationProperties applicationProperties;

    public CanChangePasswordsCondition(CrowdDirectoryService crowdDirectoryService, ApplicationProperties applicationProperties) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.applicationProperties = applicationProperties;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (this.isExternalUserManagement()) {
            return false;
        }
        return Iterables.any((Iterable)this.crowdDirectoryService.findAllDirectories(), (Predicate)new DirectoryCanChangePasswords());
    }

    private boolean isExternalUserManagement() {
        return this.applicationProperties.getOption("jira.option.user.externalmanagement");
    }

    static class DirectoryCanChangePasswords
    implements Predicate<Directory> {
        DirectoryCanChangePasswords() {
        }

        public boolean apply(@Nullable Directory directory) {
            return directory != null && directory.isActive() && directory.getType() != DirectoryType.DELEGATING && directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
        }
    }
}

