/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.passwordpolicy.analysis;

import com.google.common.collect.ImmutableSortedSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CharacterFrequencyAnalysis {
    private final Map<Character, Tally> frequency = new HashMap<Character, Tally>();

    private CharacterFrequencyAnalysis(String text) {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            Character c = Character.valueOf(text.charAt(i));
            Tally tally = this.frequency.get(c);
            if (tally == null) {
                tally = new Tally();
                this.frequency.put(c, tally);
            }
            ++tally.value;
        }
    }

    public static CharacterFrequencyAnalysis of(String text) {
        return new CharacterFrequencyAnalysis(text);
    }

    public boolean isSimilarTo(CharacterFrequencyAnalysis other) {
        if (this.frequency.keySet().equals(other.frequency.keySet())) {
            return true;
        }
        return 5 * this.getCountOfCharactersWithSimilarFrequency(other) >= 3 * this.getCountOfCharactersWithDistinctFrequency(other);
    }

    public int getMaximumFrequency() {
        int max = 0;
        for (Tally tally : this.frequency.values()) {
            if (max >= tally.value) continue;
            max = tally.value;
        }
        return max;
    }

    public int getFrequencyOf(char c) {
        Tally tally = this.frequency.get(Character.valueOf(c));
        return tally != null ? tally.value : 0;
    }

    public Set<Character> getCharacterSet() {
        return ImmutableSortedSet.copyOf(this.frequency.keySet());
    }

    private int getCountOfCharactersWithSimilarFrequency(CharacterFrequencyAnalysis other) {
        int count = 0;
        for (Map.Entry<Character, Tally> entry : this.frequency.entrySet()) {
            Tally otherTally = other.frequency.get(entry.getKey());
            if (!entry.getValue().isSimilarTo(otherTally)) continue;
            ++count;
        }
        return count;
    }

    private int getCountOfCharactersWithDistinctFrequency(CharacterFrequencyAnalysis other) {
        int count = 0;
        for (Map.Entry<Character, Tally> entry : this.frequency.entrySet()) {
            Tally otherTally = other.frequency.get(entry.getKey());
            if (entry.getValue().isSimilarTo(otherTally)) continue;
            ++count;
        }
        for (Character c : other.frequency.keySet()) {
            if (this.frequency.containsKey(c)) continue;
            ++count;
        }
        return count;
    }

    static class Tally {
        int value;

        Tally() {
        }

        boolean isSimilarTo(Tally other) {
            if (other == null) {
                return false;
            }
            if (this.value == other.value) {
                return true;
            }
            return this.value >= 3 && other.value >= 3;
        }
    }
}

