/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.passwordpolicy.actions;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugins.passwordpolicy.Message;
import com.atlassian.jira.plugins.passwordpolicy.config.ConfigItem;
import com.atlassian.jira.plugins.passwordpolicy.config.PasswordPolicyConfiguration;
import com.atlassian.jira.plugins.passwordpolicy.config.PasswordPolicyConfigurationLoader;
import com.atlassian.jira.plugins.passwordpolicy.config.PasswordPolicyMode;
import com.atlassian.jira.plugins.passwordpolicy.config.SimilarityCheck;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.velocity.htmlsafe.HtmlSafe;

@WebSudoRequired
public class EditPasswordPolicy
extends JiraWebActionSupport {
    private static final String SHOW_PASSPHRASE_EXEMPTION = "jira.password.policy.show.passphrase.exemption";
    private final PasswordPolicyConfigurationLoader passwordPolicyConfigurationLoader;
    private final FeatureManager featureManager;
    private PasswordPolicyConfiguration config;
    private PasswordPolicyMode passwordPolicyMode;
    private boolean enablePassphraseExemption;
    private boolean updated;

    public EditPasswordPolicy(PasswordPolicyConfigurationLoader passwordPolicyConfigurationLoader, FeatureManager featureManager) {
        this.passwordPolicyConfigurationLoader = passwordPolicyConfigurationLoader;
        this.featureManager = featureManager;
    }

    public PasswordPolicyConfiguration getConfig() {
        if (this.config == null) {
            this.config = this.passwordPolicyConfigurationLoader.load();
        }
        return this.config;
    }

    private void addError(ConfigItem item, String error) {
        this.addError(item.key(), error, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    private PasswordPolicyMode getPasswordPolicyMode() {
        if (this.passwordPolicyMode == null) {
            this.passwordPolicyMode = this.getConfig().getPasswordPolicyMode();
        }
        return this.passwordPolicyMode;
    }

    protected void doValidation() {
        super.doValidation();
        if (this.getPasswordPolicyMode().isCustom()) {
            this.validateCustomSettings();
        }
    }

    private void validateCustomSettings() {
        PasswordPolicyConfiguration config = this.getConfig();
        I18nHelper i18n = this.getI18nHelper();
        this.boundsCheck(ConfigItem.MINIMUM_LENGTH, config.getMinimumLength(), Message.ADMIN_MINIMUM_LENGTH_RANGE);
        if (this.boundsCheck(ConfigItem.MAXIMUM_LENGTH, config.getMaximumLength(), Message.ADMIN_MAXIMUM_LENGTH_RANGE)) {
            if (config.getMaximumLength() < config.getMinimumLength()) {
                this.addError(ConfigItem.MAXIMUM_LENGTH, Message.ADMIN_MAXIMUM_LENGTH_VS_MINIMUM.snippet(i18n));
            } else if (config.getMaximumLength() < config.getMinimumUppercase() + config.getMinimumLowercase() + config.getMinimumDigits() + config.getMinimumSpecial()) {
                this.addError(ConfigItem.MAXIMUM_LENGTH, Message.ADMIN_MAXIMUM_LENGTH_VS_CLASSES.snippet(i18n));
            } else if (config.getMaximumLength() < 16 && this.enablePassphraseExemption) {
                this.addError(ConfigItem.MAXIMUM_LENGTH, Message.ADMIN_MAXIMUM_LENGTH_VS_PASSPHRASE.snippet(i18n, 16));
            }
        }
        this.boundsCheck(ConfigItem.MINIMUM_UPPERCASE, config.getMinimumUppercase(), Message.ADMIN_PER_CLASS_RANGE);
        this.boundsCheck(ConfigItem.MINIMUM_LOWERCASE, config.getMinimumLowercase(), Message.ADMIN_PER_CLASS_RANGE);
        this.boundsCheck(ConfigItem.MINIMUM_DIGITS, config.getMinimumDigits(), Message.ADMIN_PER_CLASS_RANGE);
        this.boundsCheck(ConfigItem.MINIMUM_SPECIAL, config.getMinimumSpecial(), Message.ADMIN_PER_CLASS_RANGE);
        this.boundsCheck(ConfigItem.MINIMUM_CLASSES, config.getMinimumDistinctCharacterClasses(), Message.ADMIN_TOTAL_CLASSES_RANGE);
        if (config.getMaximumLength() < 16 && this.enablePassphraseExemption) {
            this.addError(ConfigItem.ENABLE_PASSPHRASE_EXEMPTION, Message.ADMIN_MAXIMUM_LENGTH_VS_PASSPHRASE.snippet(i18n, 16));
        }
        config.setEnablePassphraseExemption(this.enablePassphraseExemption);
        if (this.hasAnyErrors()) {
            this.addErrorMessage(Message.ADMIN_CHANGES_REJECTED.snippet(i18n));
        }
    }

    private boolean boundsCheck(ConfigItem.IntegerConfigItem configItem, int value, Message message) {
        if (configItem.isOutOfRange(value)) {
            this.addError(configItem, message.snippet(this.getI18nHelper(), configItem.minimumValue(), configItem.maximumValue()));
            return false;
        }
        return true;
    }

    @HtmlSafe
    public String getPasswordPolicyModeSelected(int value) {
        return this.isPasswordPolicyModeSelected(value) ? " checked=\"checked\"" : "";
    }

    private boolean isPasswordPolicyModeSelected(int value) {
        return this.getPasswordPolicyMode().ordinal() == value;
    }

    @HtmlSafe
    public String getMinimumClassesOptionSelected(int value) {
        return this.isMinimumClassesOptionSelected(value) ? " selected=\"selected\"" : "";
    }

    private boolean isMinimumClassesOptionSelected(int value) {
        int setting = this.getConfig().getMinimumDistinctCharacterClasses();
        switch (value) {
            case 0: {
                return setting <= 1;
            }
            case 2: {
                return setting == 2;
            }
            case 3: {
                return setting == 3;
            }
            case 4: {
                return setting >= 4;
            }
        }
        throw new IllegalArgumentException();
    }

    @HtmlSafe
    public String getBoldText(String key) {
        return "<strong>" + this.getText(key) + "</strong>";
    }

    @HtmlSafe
    public String getSimilarityTestOptionSelected(int maybe, SimilarityCheck actual) {
        return maybe == actual.ordinal() ? " selected=\"selected\"" : "";
    }

    public boolean isShowPassphraseExemption() {
        return this.featureManager.isEnabled(SHOW_PASSPHRASE_EXEMPTION);
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        PasswordPolicyMode mode = this.getPasswordPolicyMode();
        if (mode.isCustom()) {
            this.getConfig().setPasswordPolicyMode(mode);
            this.passwordPolicyConfigurationLoader.store(mode.applyTo(this.getConfig()));
        } else {
            this.config = null;
            this.passwordPolicyConfigurationLoader.store(mode.applyTo(this.getConfig()));
        }
        this.config = null;
        this.updated = true;
        return "success";
    }

    public void setMinimumUppercase(int value) {
        this.getConfig().setMinimumUppercase(value);
    }

    public void setMinimumLowercase(int value) {
        this.getConfig().setMinimumLowercase(value);
    }

    public void setMinimumDigits(int value) {
        this.getConfig().setMinimumDigits(value);
    }

    public void setMinimumSpecial(int value) {
        this.getConfig().setMinimumSpecial(value);
    }

    public void setMinimumLength(int value) {
        this.getConfig().setMinimumLength(value);
    }

    public void setMaximumLength(int value) {
        this.getConfig().setMaximumLength(value);
    }

    public void setMinimumClasses(int value) {
        this.getConfig().setMinimumDistinctCharacterClasses(value);
    }

    public void setSimilarityToUserInfo(int value) {
        this.getConfig().setSimilarityToUserInfo(SimilarityCheck.from(value));
    }

    public void setSimilarityToOldPassword(int value) {
        this.getConfig().setSimilarityToOldPassword(SimilarityCheck.from(value));
    }

    public void setPasswordPolicyMode(int value) {
        this.passwordPolicyMode = PasswordPolicyMode.from(value);
    }

    public void setEnablePassphraseExemption(String enabled) {
        this.enablePassphraseExemption = Boolean.valueOf(enabled);
    }

    public boolean isUpdated() {
        return this.updated;
    }
}

