/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web.redirect;

import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.legacy.LegacyProjectTabToSidebarItemTransformer;
import com.atlassian.jira.projects.url.ProjectUrlComponents;
import com.atlassian.jira.projects.web.redirect.IssueNavigatorUrlGenerator;
import com.atlassian.jira.util.UrlBuilder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectUrlToLegacyBrowseUrlTransformer {
    private final LegacyProjectTabToSidebarItemTransformer projectTabToSidebarItem;
    private final IssueNavigatorUrlGenerator issueNavUrlGenerator;

    @Autowired
    public ProjectUrlToLegacyBrowseUrlTransformer(LegacyProjectTabToSidebarItemTransformer projectTabToSidebarItem, IssueNavigatorUrlGenerator issueNavUrlGenerator) {
        this.projectTabToSidebarItem = projectTabToSidebarItem;
        this.issueNavUrlGenerator = issueNavUrlGenerator;
    }

    public Option<String> getTransformedUrl(ProjectUrlComponents urlComponents) {
        if (this.isUrlForSidebarIssueNavigator(urlComponents)) {
            return this.getIssueNavigatorUrl(urlComponents);
        }
        if (this.isUrlForSummaryPageShowingStatistics(urlComponents)) {
            return this.getLegacyIssueStatisticsUrl(urlComponents);
        }
        return this.getLegacyBrowseProjectUrl(urlComponents);
    }

    private Option<String> getIssueNavigatorUrl(ProjectUrlComponents urlComponents) {
        return Option.some((Object)this.issueNavUrlGenerator.generateAllIssuesInProjectUrl(urlComponents.getContextPath(), urlComponents.getProjectKey()));
    }

    private Option<String> getLegacyBrowseProjectUrl(ProjectUrlComponents urlComponents) {
        String contextPath = urlComponents.getContextPath();
        UrlBuilder url = new UrlBuilder(contextPath, false);
        url.addPath("browse").addPath(urlComponents.getProjectKey());
        Option<String> projectTab = this.projectTabToSidebarItem.transformToProjectTab((String)urlComponents.getSelectedItem().getOrNull());
        if (projectTab.isDefined()) {
            url.addParameter("selectedTab", (String)projectTab.get());
        }
        return Option.some((Object)url.asUrlString());
    }

    private boolean isUrlForSidebarIssueNavigator(ProjectUrlComponents urlComponents) {
        return this.isSidebarIssueNavSpecifiedAsTrailingSegments(urlComponents) || this.isSidebarIssueNavSpecifiedAsSelectedItem(urlComponents);
    }

    private boolean isSidebarIssueNavSpecifiedAsTrailingSegments(ProjectUrlComponents urlComponents) {
        List trailingSegments = urlComponents.getTrailingSegments();
        return !trailingSegments.isEmpty() && "issues".equals(trailingSegments.get(0));
    }

    private boolean isSidebarIssueNavSpecifiedAsSelectedItem(ProjectUrlComponents urlComponents) {
        Option selectedItem = urlComponents.getSelectedItem();
        return selectedItem.isDefined() && "com.atlassian.jira.jira-projects-issue-navigator:sidebar-issue-navigator".equals(selectedItem.get());
    }

    private boolean isUrlForSummaryPageShowingStatistics(ProjectUrlComponents urlComponents) {
        List trailingSegments = urlComponents.getTrailingSegments();
        return trailingSegments != null && trailingSegments.size() == 2 && "summary".equals(trailingSegments.get(0)) && "statistics".equals(trailingSegments.get(1));
    }

    private Option<String> getLegacyIssueStatisticsUrl(ProjectUrlComponents urlComponents) {
        String url = "/browse/" + urlComponents.getProjectKey() + "?selectedTab=com.atlassian.jira.jira-projects-plugin:issues-panel";
        if ("/".equals(urlComponents.getContextPath())) {
            return Option.some((Object)url);
        }
        return Option.some((Object)(urlComponents.getContextPath() + url));
    }
}

