/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web.redirect;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.url.ProjectUrlComponents;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ProjectUrlComponentsExtractor {
    private static final String SELECTED_ITEM_PARAM = "selectedItem";

    public Either<ErrorCollection, ProjectUrlComponents> extractComponents(String contextPath, String urlPath, Map<String, String[]> urlParameters) {
        ArrayList pathSegments = Lists.newArrayList((Object[])StringUtils.split((String)urlPath, (String)"/"));
        List trailingSegments = pathSegments.subList(2, pathSegments.size());
        String key = (String)pathSegments.get(1);
        if (!JiraKeyUtils.validProjectKey((String)key)) {
            return ProjectUrlComponentsExtractor.error(ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return Either.right((Object)new ProjectUrlComponents(contextPath, key, this.extractSelectedItemFrom(urlParameters), trailingSegments, this.extractQueryStringParams(urlParameters)));
    }

    private Option<String> extractSelectedItemFrom(Map<String, String[]> parameters) {
        if (parameters.get(SELECTED_ITEM_PARAM) == null || parameters.get(SELECTED_ITEM_PARAM).length < 1) {
            return Option.none();
        }
        return Option.some((Object)parameters.get(SELECTED_ITEM_PARAM)[0]);
    }

    private Map<String, String[]> extractQueryStringParams(Map<String, String[]> urlParameters) {
        HashMap queryStringParameters = Maps.newHashMap(urlParameters);
        queryStringParameters.remove(SELECTED_ITEM_PARAM);
        return queryStringParameters;
    }

    private static Either<ErrorCollection, ProjectUrlComponents> error(ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addReason(reason);
        return ServiceResult.error((ErrorCollection)errorCollection);
    }
}

