/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web.redirect;

import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueNavigatorUrlGenerator {
    private final JqlStringSupport jqlStringSupport;

    @Autowired
    public IssueNavigatorUrlGenerator(@ComponentImport JqlStringSupport jqlStringSupport) {
        this.jqlStringSupport = jqlStringSupport;
    }

    public String generateAllIssuesInProjectUrl(String contextPath, String projectKey) {
        String jql = this.jqlStringSupport.generateJqlString(this.getJqlQuery(projectKey));
        jql = URLEncoder.encodeQueryStringValue(jql);
        String url = "/issues/?jql=" + jql;
        if ("/".equals(contextPath)) {
            return url;
        }
        return contextPath + url;
    }

    @VisibleForTesting
    Query getJqlQuery(String projectKey) {
        return JqlQueryBuilder.newBuilder().where().project(new String[]{projectKey}).endWhere().orderBy().createdDate(SortOrder.DESC).endOrderBy().buildQuery();
    }
}

