/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.util;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebPanelRenderer {
    private final DynamicWebInterfaceManager webInterfaceManager;
    private static final Logger log = Logger.getLogger(WebPanelRenderer.class);

    @Autowired
    public WebPanelRenderer(@ComponentImport DynamicWebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public boolean renderWebPanels(Writer out, String panelLocation, Map<String, Object> context) {
        try {
            List webPanelDescriptors = this.webInterfaceManager.getDisplayableWebPanelDescriptors(panelLocation, context);
            if (webPanelDescriptors.isEmpty()) {
                return false;
            }
            for (WebPanelModuleDescriptor webPanelDescriptor : webPanelDescriptors) {
                try {
                    ((WebPanel)webPanelDescriptor.getModule()).writeHtml(out, context);
                }
                catch (RuntimeException e) {
                    log.warn((Object)("Cannot render WebPanel with key '" + webPanelDescriptor.getCompleteKey() + "'"), (Throwable)e);
                }
                catch (IOException e) {
                    log.warn((Object)("Cannot write WebPanel with key '" + webPanelDescriptor.getCompleteKey() + "' to the output"), (Throwable)e);
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            log.warn((Object)("Cannot fetch WebPanels for location '" + panelLocation + "'"), (Throwable)e);
            return false;
        }
    }

    public Option<String> renderWebPanels(String panelLocation, Map<String, Object> context) {
        StringWriter writer = new StringWriter();
        if (this.renderWebPanels(writer, panelLocation, context)) {
            return Option.some((Object)writer.toString());
        }
        return Option.none();
    }
}

