/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.util;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectPermissions {
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;

    @Autowired
    public ProjectPermissions(@ComponentImport PermissionManager permissionManager, @ComponentImport GlobalPermissionManager globalPermissionManager) {
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
    }

    public Boolean hasProjectAdminPermission(ApplicationUser user, Project project) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) || this.permissionManager.hasPermission(com.atlassian.jira.permission.ProjectPermissions.ADMINISTER_PROJECTS, project, user);
    }
}

