/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.util;

import com.google.common.annotations.VisibleForTesting;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OptionalServiceRef<T> {
    private final BundleContext bundleContext;
    private final ServiceReference serviceReference;
    private final String serviceClassName;

    OptionalServiceRef(BundleContext bundleContext, String serviceClassName) {
        this(bundleContext, serviceClassName, bundleContext.getServiceReference(serviceClassName));
    }

    @VisibleForTesting
    OptionalServiceRef(BundleContext bundleContext, String serviceClassName, ServiceReference serviceReference) {
        this.bundleContext = bundleContext;
        this.serviceClassName = serviceClassName;
        this.serviceReference = serviceReference;
    }

    public boolean isAvailable() {
        return this.serviceReference != null;
    }

    public T get() {
        if (this.serviceReference == null) {
            throw new IllegalStateException("You have called on get() without checking that the service is in fact available!");
        }
        return (T)this.bundleContext.getService(this.serviceReference);
    }

    public boolean release() {
        return this.serviceReference != null && this.bundleContext.ungetService(this.serviceReference);
    }

    public String toString() {
        return String.format("%s : %s", this.serviceClassName, this.isAvailable() ? "available" : "not available");
    }
}

