/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.util;

import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.projects.api.service.FlushHeadEarlyUtils;
import com.atlassian.jira.projects.util.FlushHeadEarlyService;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.pagebuilder.Decorator;
import com.atlassian.jira.web.pagebuilder.GeneralJspDecorator;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.jira.web.pagebuilder.PageBuilder;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Scanned
public class DefaultFlushHeadEarlyService
implements FlushHeadEarlyService {
    private static final Logger log = LoggerFactory.getLogger(DefaultFlushHeadEarlyService.class);
    private static final Pattern SPLIT_REGEX = Pattern.compile("[\\s,]+");
    private static final String FLUSH_HEAD_EARLY_RESOURCES_MODULE_PARAM = "flushHeadEarlyResources";
    private static final Map<String, BiConsumer<DefaultFlushHeadEarlyService, String>> WEB_RESOURCE_TYPES = MapBuilder.newBuilder().add((Object)"wrc", (service, resource) -> service.jiraPageBuilderService.assembler().resources().requireContext(resource)).add((Object)"wr", (service, resource) -> service.jiraPageBuilderService.assembler().resources().requireWebResource(resource)).add((Object)"kb", (service, resource) -> {
        try {
            service.keyboardShortcutManager.requireShortcutsForContext(KeyboardShortcutManager.Context.valueOf((String)resource));
        }
        catch (IllegalArgumentException exception) {
            log.warn("Can't load keyboard shortcut context \"{}\". Please, check that it is a valid com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager.Context.", resource);
        }
    }).toMap();
    private final JiraPageBuilderService jiraPageBuilderService;
    private final WebInterfaceManager webInterfaceManager;
    private final FlushHeadEarlyUtils flushHeadEarlyUtils;
    private KeyboardShortcutManager keyboardShortcutManager;

    @Inject
    public DefaultFlushHeadEarlyService(@ComponentImport JiraPageBuilderService jiraPageBuilderService, WebInterfaceManager webInterfaceManager, FlushHeadEarlyUtils flushHeadEarlyUtils, @ComponentImport KeyboardShortcutManager keyboardShortcutManager) {
        this.jiraPageBuilderService = jiraPageBuilderService;
        this.webInterfaceManager = webInterfaceManager;
        this.flushHeadEarlyUtils = flushHeadEarlyUtils;
        this.keyboardShortcutManager = keyboardShortcutManager;
    }

    public boolean isFlushHeadEarly() {
        return this.flushHeadEarlyUtils.isEnabled();
    }

    public void requireResourcesOfItem(String item) {
        List webPanelDescriptors = this.webInterfaceManager.getWebPanelDescriptors(item);
        webPanelDescriptors.stream().map(ModuleDescriptor::getParams).map(params -> (String)params.get(FLUSH_HEAD_EARLY_RESOURCES_MODULE_PARAM)).map(String::trim).map(SPLIT_REGEX::split).flatMap(Arrays::stream).forEach(webResource -> WEB_RESOURCE_TYPES.entrySet().stream().filter(type -> webResource.startsWith((String)type.getKey() + "!")).findFirst().ifPresent(type -> ((BiConsumer)type.getValue()).accept(this, webResource.substring(((String)type.getKey()).length() + 1))));
    }

    public void flush() {
        if (!this.isFlushHeadEarly()) {
            throw new IllegalStateException("Attempting to flush when flush head early is not enabled");
        }
        PageBuilder pageBuilder = this.jiraPageBuilderService.get();
        pageBuilder.setDecorator((Decorator)new GeneralJspDecorator(this.jiraPageBuilderService.assembler()));
        pageBuilder.flush();
    }
}

