/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.util;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.browse.BrowseProjectContext;
import com.atlassian.jira.projects.util.Preconditions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BrowseContextFactory {
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectService projectService;

    @Autowired
    public BrowseContextFactory(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ProjectService projectService) {
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
    }

    public BrowseContext create(String key) {
        ApplicationUser currentUser = this.authenticationContext.getUser();
        Project project = Preconditions.checkProjectNotNull(key, this.projectService.getProjectByKey(currentUser, key));
        return new BrowseProjectContext(currentUser, project);
    }
}

