/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.tabpanel;

import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.projects.tabpanel.TabPanelService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Map;

public class TabPanelExistsCondition
implements Condition {
    private final TabPanelService tabPanelService;

    public TabPanelExistsCondition(TabPanelService tabPanelService) {
        this.tabPanelService = tabPanelService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String projectKey = String.valueOf(context.get("projectKey"));
        String tabPanelKey = String.valueOf(context.get("tabPanelKey"));
        return Iterables.any(this.getTabPanels(projectKey), TabPanelExistsCondition.hasCompleteKey(tabPanelKey));
    }

    private Iterable<ProjectTabPanelModuleDescriptor> getTabPanels(String projectKey) {
        return this.tabPanelService.getVisibleTabPanelDescriptorsForProject(projectKey);
    }

    private static Predicate<ProjectTabPanelModuleDescriptor> hasCompleteKey(final String completeKey) {
        return new Predicate<ProjectTabPanelModuleDescriptor>(){

            public boolean apply(ProjectTabPanelModuleDescriptor tabPanel) {
                return tabPanel != null && completeKey.equals(tabPanel.getCompleteKey());
            }
        };
    }
}

