/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.navigation;

import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItemService;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationSection;
import com.atlassian.jira.projects.badges.SidebarBadgesService;
import com.atlassian.jira.projects.compatibility.AtlassianConnect;
import com.atlassian.jira.projects.sidebar.navigation.WebFragmentContextService;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.WebSection;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class NavigationItemServiceImpl
implements NavigationItemService {
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final WebFragmentContextService webFragmentContextService;
    private final SidebarBadgesService badgesService;

    @Autowired
    public NavigationItemServiceImpl(@ComponentImport DynamicWebInterfaceManager webInterfaceManager, WebFragmentContextService webFragmentContextService, SidebarBadgesService badgesService) {
        this.webInterfaceManager = webInterfaceManager;
        this.webFragmentContextService = webFragmentContextService;
        this.badgesService = badgesService;
    }

    public List<NavigationItem> getItemsInSection(String section, Map<String, Object> context) {
        Map<String, Object> contextWithDefaults = this.makeContext(context);
        return Lists.transform(this.getWebItems(section, contextWithDefaults), this.toNavigationItem(contextWithDefaults));
    }

    public List<NavigationSection> getSectionsForLocation(String location, Map<String, Object> context) {
        Map<String, Object> contextWithDefaults = this.makeContext(context);
        return Lists.transform(this.getWebSections(location, contextWithDefaults), this.toNavigationSection(contextWithDefaults));
    }

    private List<WebItem> getWebItems(String section, Map<String, Object> context) {
        return Lists.newArrayList((Iterable)this.webInterfaceManager.getDisplayableWebItems(AtlassianConnect.removeConnectPluginPrefix(section), context));
    }

    private Function<WebItem, NavigationItem> toNavigationItem(final Map<String, Object> context) {
        return new Function<WebItem, NavigationItem>(){

            public NavigationItem apply(WebItem webItem) {
                List children = Lists.transform((List)NavigationItemServiceImpl.this.getWebItems(webItem.getCompleteKey(), context), (Function)NavigationItemServiceImpl.this.toNavigationItem(context));
                Map params = webItem.getParams();
                NavigationItem.Builder builder = NavigationItem.builder().setHref(webItem.getUrl()).setId(webItem.getCompleteKey()).setStyleClass(StringUtils.defaultIfBlank((String)webItem.getStyleClass(), (String)((String)params.get("styleClass")))).setLabel(webItem.getLabel()).setIconClass((String)params.get("iconClass")).setIconUrl((String)params.get("iconUrl")).addChildren(children);
                if (NavigationItemServiceImpl.this.shouldDisplayNavigationItemBadge(webItem)) {
                    builder.setBadgeLabel((String)params.get("badgeLabel"));
                    builder.setBadgeDescription((String)params.get("badgeDescription"));
                }
                return builder.build();
            }
        };
    }

    private boolean shouldDisplayNavigationItemBadge(WebItem webItem) {
        String webItemBadgeLabel = (String)webItem.getParams().get("badgeLabel");
        String sidebarLinkId = webItem.getCompleteKey();
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)webItemBadgeLabel) && this.badgesService.canDisplayBadgeFor(sidebarLinkId);
    }

    private List<WebSection> getWebSections(String location, Map<String, Object> context) {
        return Lists.newArrayList((Iterable)this.webInterfaceManager.getDisplayableWebSections(AtlassianConnect.removeConnectPluginPrefix(location), context));
    }

    private Function<WebSection, NavigationSection> toNavigationSection(final Map<String, Object> context) {
        return new Function<WebSection, NavigationSection>(){

            public NavigationSection apply(WebSection webSection) {
                List items = Lists.transform((List)NavigationItemServiceImpl.this.getWebItems(webSection.getLocation() + "/" + webSection.getId(), context), (Function)NavigationItemServiceImpl.this.toNavigationItem(context));
                return NavigationSection.builder().setId(webSection.getCompleteKey()).setLabel(webSection.getLabel()).addItems(items).build();
            }
        };
    }

    private Map<String, Object> makeContext(Map<String, Object> source) {
        HashMap context = Maps.newHashMap();
        context.putAll(this.webFragmentContextService.getDefaultWebFragmentContext());
        context.putAll(source);
        Project project = (Project)context.get("project");
        if (project != null) {
            context.put("helper", new JiraHelper(ExecutingHttpRequest.get(), project));
        }
        return context;
    }
}

