/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.lastvisited;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.sidebar.lastvisited.LastVisitedItemInProjectService;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="project/{projectKey}/lastVisited")
public class LastVisitedItemResource {
    private final LastVisitedItemInProjectService lastVisitedItemService;
    private final ProjectService projectService;

    public LastVisitedItemResource(LastVisitedItemInProjectService lastVisitedItemService, ProjectService projectService) {
        this.lastVisitedItemService = lastVisitedItemService;
        this.projectService = projectService;
    }

    @PUT
    public Response updateLastVisitedItem(@PathParam(value="projectKey") String projectKey, LastVisitedItem lastVisited) {
        Either<ErrorCollection, Project> project = this.projectService.getProject(projectKey);
        if (project.isLeft()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Optional<ErrorCollection> errors = this.lastVisitedItemService.setLastVisitedItemIdForProject((Project)project.right().get(), lastVisited.id);
        return Response.status((Response.Status)errors.map(e -> Response.Status.BAD_REQUEST).orElse(Response.Status.OK)).build();
    }

    @XmlRootElement
    static class LastVisitedItem {
        @XmlElement
        private String id;

        LastVisitedItem() {
        }

        LastVisitedItem(String id) {
            this.id = id;
        }
    }
}

