/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.header;

import com.atlassian.jira.projects.api.sidebar.header.ScopeFilter;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.json.marshal.JsonableMarshaller;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class ScopeFilterJsonableMarshaller
implements JsonableMarshaller {
    static final String SELECTED_SCOPE_PROPERTY_NAME = "selectedScope";
    static final String SCOPES_PROPERTY_NAME = "scopes";
    static final String CREATE_SCOPE_ACTIONS_PROPERTY_NAME = "createScopeActions";
    static final String SCOPE_LABEL_PROPERTY_NAME = "label";
    static final String SCOPE_LINK_PROPERTY_NAME = "link";
    static final String SCOPE_STYLE_CLASS_PROPERTY_NAME = "styleClass";

    ScopeFilterJsonableMarshaller() {
    }

    public Jsonable marshal(Object scopeFilterObj) {
        Preconditions.checkArgument((boolean)(scopeFilterObj instanceof ScopeFilter));
        ScopeFilter scopeFilter = (ScopeFilter)scopeFilterObj;
        final Map<String, Object> scopeFilterProperties = this.asMap(scopeFilter);
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                Gson gson = new Gson();
                writer.write(gson.toJson((Object)scopeFilterProperties));
            }
        };
    }

    private Map<String, Object> asMap(ScopeFilter scopeFilter) {
        MapBuilder mapBuilder = MapBuilder.newBuilder().add((Object)SCOPES_PROPERTY_NAME, this.asJsonableCollection(scopeFilter.getScopeFilterItems())).add((Object)CREATE_SCOPE_ACTIONS_PROPERTY_NAME, this.asJsonableCollection(scopeFilter.getCreateNewItems()));
        if (scopeFilter.getSelectedScopeItem() != null) {
            mapBuilder.add((Object)SELECTED_SCOPE_PROPERTY_NAME, this.asMap(scopeFilter.getSelectedScopeItem()));
        }
        return mapBuilder.toMap();
    }

    private Map<String, Object> asMap(NavigationItem navigationItem) {
        return MapBuilder.newBuilder().add((Object)SCOPE_LABEL_PROPERTY_NAME, (Object)navigationItem.getLabel()).add((Object)SCOPE_LINK_PROPERTY_NAME, (Object)navigationItem.getHref()).add((Object)SCOPE_STYLE_CLASS_PROPERTY_NAME, (Object)navigationItem.getStyleClass()).toMap();
    }

    private Collection<Map<String, Object>> asJsonableCollection(List<NavigationItem> scopeFilterItems) {
        if (scopeFilterItems.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.transform(scopeFilterItems, (Function)new Function<NavigationItem, Map<String, Object>>(){

            public Map<String, Object> apply(NavigationItem navigationItem) {
                return ScopeFilterJsonableMarshaller.this.asMap(navigationItem);
            }
        });
    }
}

