/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.header;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeIconRenderer;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.warning.InaccessibleProjectTypeDialogDataProvider;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.api.sidebar.header.HeaderRenderer;
import com.atlassian.jira.projects.api.sidebar.header.HeaderRendererParameters;
import com.atlassian.jira.projects.api.sidebar.header.HeaderRendererParametersBuilder;
import com.atlassian.jira.projects.api.sidebar.header.ProjectHeaderRenderer;
import com.atlassian.jira.projects.api.sidebar.header.ScopeFilter;
import com.atlassian.jira.projects.api.sidebar.header.ScopeFilterBuilder;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItemService;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationSection;
import com.atlassian.jira.projects.sidebar.header.ScopeFilterJsonableMarshaller;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ProjectHeaderRendererImpl
implements ProjectHeaderRenderer {
    private final AvatarService avatarService;
    private final HeaderRenderer headerRenderer;
    private final NavigationItemService navigationItemService;
    private final ProjectContextPopulator contextPopulator;
    private final PageBuilderService pageBuilderService;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectTypeIconRenderer projectTypeIconRenderer;
    private final InaccessibleProjectTypeDialogDataProvider inaccessibleProjectTypeDialogDataProvider;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private static final String HEADER_SECTION = "jira.project.sidebar.header";
    private static final String SUMMARY_LINK = "/projects/%s/summary";
    private static final String SCOPE_FILTER_OPTIONS_KEY = "project-sidebar-header-scope-filter-list";
    private static final String HAS_CREATE_PERMISSION_KEY = "project-sidebar-header-create-new-section";
    private static final String PROJECT_HEADER_DEFAULT_PAGE_LOCATION = "jira.project.header.defaultpage";

    @Autowired
    public ProjectHeaderRendererImpl(HeaderRenderer headerRenderer, NavigationItemService navigationItemService, ProjectContextPopulator contextPopulator, @ComponentImport JiraPageBuilderService pageBuilderService, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport AvatarService avatarService, @ComponentImport ProjectTypeIconRenderer projectTypeIconRenderer, @ComponentImport InaccessibleProjectTypeDialogDataProvider inaccessibleProjectTypeDialogDataProvider, @ComponentImport DynamicWebInterfaceManager webInterfaceManager) {
        this.avatarService = avatarService;
        this.headerRenderer = headerRenderer;
        this.navigationItemService = navigationItemService;
        this.contextPopulator = contextPopulator;
        this.pageBuilderService = pageBuilderService;
        this.authenticationContext = authenticationContext;
        this.projectTypeIconRenderer = projectTypeIconRenderer;
        this.inaccessibleProjectTypeDialogDataProvider = inaccessibleProjectTypeDialogDataProvider;
        this.webInterfaceManager = webInterfaceManager;
    }

    public String render(Project project, String selectedItemId) {
        Option<List<NavigationSection>> sectionsForScopeFilter = this.getSectionsForScopeFilter(HEADER_SECTION, project);
        ScopeFilter scopeFilter = this.createScopeFilter(sectionsForScopeFilter);
        ProjectTypeKey projectTypeKey = project.getProjectTypeKey();
        HeaderRendererParameters headerParameters = new HeaderRendererParametersBuilder().avatarUrl(this.getProjectAvatarUrl(project)).heading(project.getName()).linkUrl(this.getProjectLinkUrl(project)).selected("com.atlassian.jira.jira-projects-plugin:summary-page".equals(selectedItemId)).scopeFilter(scopeFilter).projectTypeKey(projectTypeKey.getKey()).projectTypeIcon(this.getProjectTypeIcon(projectTypeKey)).displayProjectTypeWarning(this.shouldDisplayProjectTypeWarning(project)).build();
        this.addScopeFilterDataToPage(scopeFilter);
        this.addProjectTypeWarningDialogDataToPage(project);
        return this.headerRenderer.render(headerParameters);
    }

    private void addProjectTypeWarningDialogDataToPage(Project project) {
        if (this.shouldDisplayProjectTypeWarning(project)) {
            this.inaccessibleProjectTypeDialogDataProvider.provideData(this.pageBuilderService.assembler(), this.authenticationContext.getLoggedInUser(), project);
        }
    }

    private boolean shouldDisplayProjectTypeWarning(Project project) {
        return this.inaccessibleProjectTypeDialogDataProvider.shouldDisplayInaccessibleWarning(this.authenticationContext.getLoggedInUser(), project);
    }

    private String getProjectTypeIcon(ProjectTypeKey projectTypeKey) {
        return this.projectTypeIconRenderer.getIconToRender(projectTypeKey).orElse(null);
    }

    private void addScopeFilterDataToPage(ScopeFilter scopeFilter) {
        ScopeFilterJsonableMarshaller scopeFilterJsonableMarshaller = new ScopeFilterJsonableMarshaller();
        this.pageBuilderService.assembler().data().requireData("scope-filter-data", scopeFilterJsonableMarshaller.marshal(scopeFilter));
    }

    private ScopeFilter createScopeFilter(Option<List<NavigationSection>> sectionsForScopeFilter) {
        List<NavigationItem> scopeFilterItems = this.getItemsForSection(sectionsForScopeFilter, SCOPE_FILTER_OPTIONS_KEY);
        List<NavigationItem> createNewItems = this.getItemsForSection(sectionsForScopeFilter, HAS_CREATE_PERMISSION_KEY);
        NavigationItem selectedItem = scopeFilterItems.size() > 0 ? scopeFilterItems.get(0) : null;
        return new ScopeFilterBuilder().filterItems(scopeFilterItems).selectedItem(selectedItem).createNewItems(createNewItems).build();
    }

    private String getProjectAvatarUrl(Project project) {
        return this.avatarService.getProjectAvatarURL(project, Avatar.Size.LARGE).toString();
    }

    private Option<List<NavigationSection>> getSectionsForScopeFilter(String locationName, Project project) {
        Map newContext = this.contextPopulator.populateWithProject((Project)Preconditions.checkNotNull((Object)project));
        List sectionsForLocation = this.navigationItemService.getSectionsForLocation(locationName, newContext);
        return sectionsForLocation.isEmpty() ? Option.none() : Option.some((Object)sectionsForLocation);
    }

    private List<NavigationItem> getItemsForSection(Option<List<NavigationSection>> givenSections, String key) {
        Option<NavigationSection> section = this.getSection(givenSections, key);
        List items = Lists.newArrayList();
        if (section.isDefined()) {
            items = ((NavigationSection)section.get()).getItems();
        }
        return items;
    }

    private Option<NavigationSection> getSection(Option<List<NavigationSection>> givenSections, String key) {
        if (!givenSections.isDefined()) {
            return Option.none();
        }
        Option returnSection = Option.none();
        for (NavigationSection section : (List)givenSections.get()) {
            if (!section.getId().contains(key)) continue;
            returnSection = Option.some((Object)section);
        }
        return returnSection;
    }

    private String getProjectLinkUrl(Project project) {
        String encodedProjectKey = URLEncoder.encodePathSegment(project.getKey());
        String defaultLinkUrl = String.format(SUMMARY_LINK, encodedProjectKey);
        Map context = this.contextPopulator.populateWithProject(project);
        return (String)Iterables.first((Iterable)this.webInterfaceManager.getDisplayableWebItems(PROJECT_HEADER_DEFAULT_PAGE_LOCATION, context)).flatMap(webItem -> SafePluginPointAccess.call(() -> ((WebItem)webItem).getUrl())).getOrElse((Object)defaultLinkUrl);
    }
}

