/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.contentregistry;

import com.atlassian.fugue.Option;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.projects.api.sidebar.content.ProjectContentRenderer;
import com.atlassian.jira.projects.api.sidebar.content.ProjectContentRendererRegistry;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ProjectContentRendererRegistryImpl
implements ProjectContentRendererRegistry {
    private final Map<ProjectTypeKey, ProjectContentRenderer> registry;
    private final ProjectContentRenderer defaultContentRenderer;

    @Autowired
    public ProjectContentRendererRegistryImpl(ProjectContentRenderer defaultContentRenderer) {
        this.defaultContentRenderer = defaultContentRenderer;
        this.registry = new ConcurrentHashMap<ProjectTypeKey, ProjectContentRenderer>();
    }

    public void register(ProjectTypeKey projectType, ProjectContentRenderer renderer) {
        this.registry.put(projectType, renderer);
    }

    public void unregister(ProjectTypeKey projectType) {
        this.registry.remove(projectType);
    }

    public ProjectContentRenderer getRenderer(ProjectTypeKey projectTypeKey) {
        Option projectContentRenderer = Option.option((Object)this.registry.get(projectTypeKey));
        return (ProjectContentRenderer)projectContentRenderer.getOrElse((Object)this.defaultContentRenderer);
    }
}

