/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.shortcuts.events;

import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.shortcuts.ProjectShortcut;
import com.atlassian.jira.projects.shortcuts.events.ProtocolType;
import com.atlassian.jira.projects.shortcuts.events.ShortcutCreatedEvent;
import com.atlassian.jira.projects.shortcuts.events.ShortcutDeletedEvent;
import com.atlassian.jira.projects.shortcuts.events.ShortcutEditedEvent;
import com.atlassian.jira.projects.shortcuts.events.ShortcutValidatedEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ShortcutEvent {
    private final Integer shortcutId;
    private final Long projectId;
    private final Integer nameLength;
    private final Integer urlLength;
    private final String iconName;
    private final Boolean isWithIcons;

    protected ShortcutEvent(Integer shortcutId, Long projectId, Integer nameLength, Integer urlLength, String iconName, Boolean isWithIcons) {
        this.shortcutId = shortcutId;
        this.projectId = projectId;
        this.nameLength = nameLength;
        this.urlLength = urlLength;
        this.iconName = iconName;
        this.isWithIcons = isWithIcons;
    }

    public Integer getShortcutId() {
        return this.shortcutId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Integer getNameLength() {
        return this.nameLength;
    }

    public Integer getUrlLength() {
        return this.urlLength;
    }

    public String getIconName() {
        return this.iconName;
    }

    public Boolean getIsWithIcons() {
        return this.isWithIcons;
    }

    public static class Builder {
        private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^([a-zA-Z]+):", 2);
        private final Integer shortcutId;
        private final Long projectId;
        private final Integer nameLength;
        private final Integer urlLength;
        private final String iconName;
        private final Boolean isWithIcons;
        private final ProjectShortcut shortcut;

        private Builder(ProjectShortcut shortcut, Boolean isWithIcons) {
            this.shortcutId = shortcut.getId();
            this.projectId = shortcut.getProject() != null ? shortcut.getProject().getId() : null;
            this.nameLength = shortcut.getName() != null ? Integer.valueOf(shortcut.getName().length()) : null;
            this.urlLength = shortcut.getUrl() != null ? Integer.valueOf(shortcut.getUrl().length()) : null;
            this.iconName = shortcut.getIcon();
            this.isWithIcons = isWithIcons;
            this.shortcut = shortcut;
        }

        public static Builder from(ProjectShortcut shortcut, Boolean isWithIcons) {
            return new Builder(shortcut, isWithIcons);
        }

        public ShortcutCreatedEvent created() {
            return new ShortcutCreatedEvent(this.shortcutId, this.projectId, this.nameLength, this.urlLength, this.iconName, this.isWithIcons);
        }

        public ShortcutDeletedEvent deleted() {
            return new ShortcutDeletedEvent(this.shortcutId, this.projectId, this.nameLength, this.urlLength, this.iconName, this.isWithIcons);
        }

        public ShortcutEditedEvent edited(Integer oldNameLength, Integer oldUrlLength, String oldIconName) {
            return new ShortcutEditedEvent(this.shortcutId, this.projectId, this.nameLength, this.urlLength, this.iconName, this.isWithIcons, oldNameLength, oldUrlLength, oldIconName);
        }

        public ShortcutValidatedEvent validated(boolean successful) {
            Matcher matcher;
            String protocol = null;
            if (this.shortcut.getUrl() != null && (matcher = PROTOCOL_PATTERN.matcher(this.shortcut.getUrl())).find()) {
                protocol = matcher.group(1);
            }
            Integer protocolType = (Integer)Option.option(protocol).flatMap(ProtocolType.FROM_PROTOCOL_STRING).map(ProtocolType.TO_ID).getOrElse((Object)-1);
            return new ShortcutValidatedEvent(this.shortcutId, this.projectId, this.nameLength, this.urlLength, this.iconName, this.isWithIcons, successful, protocolType);
        }
    }
}

