/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.shortcuts;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.context.ShortcutsWebPanelContextProvider;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.projects.shortcuts.ProjectPermissionsHelper;
import com.atlassian.jira.projects.shortcuts.ProjectShortcut;
import com.atlassian.jira.projects.shortcuts.ShortcutsResource;
import com.atlassian.jira.projects.shortcuts.ShortcutsService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ShortcutsWebPanelContextProviderImpl
extends AbstractProjectsPageContextProvider
implements ShortcutsWebPanelContextProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ShortcutsService shortcutsService;
    private final DarkFeatureManager darkFeatureManager;
    private PageBuilderService pageBuilderService;
    private JaxbJsonMarshaller jaxbJsonMarshaller;
    private ProjectPermissionsHelper projectPermissionsHelper;
    private static final ImmutableList<ProjectShortcutIcon> ICONS_LIST = ImmutableList.of((Object)new ProjectShortcutIcon("1", "project-shortcuts-icon-link"), (Object)new ProjectShortcutIcon("2", "project-shortcuts-icon-cloud"), (Object)new ProjectShortcutIcon("3", "project-shortcuts-icon-folder"), (Object)new ProjectShortcutIcon("4", "project-shortcuts-icon-file"), (Object)new ProjectShortcutIcon("5", "project-shortcuts-icon-important"), (Object)new ProjectShortcutIcon("6", "project-shortcuts-icon-confluence"), (Object)new ProjectShortcutIcon("7", "project-shortcuts-icon-hipchat"), (Object)new ProjectShortcutIcon("8", "project-shortcuts-icon-bitbucket"), (Object)new ProjectShortcutIcon("9", "project-shortcuts-icon-crucible"), (Object)new ProjectShortcutIcon("10", "project-shortcuts-icon-fisheye"));

    @Autowired
    public ShortcutsWebPanelContextProviderImpl(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport DarkFeatureManager darkFeatureManager, ShortcutsService shortcutsService, @ComponentImport JiraPageBuilderService pageBuilderService, @ComponentImport JaxbJsonMarshaller jaxbJsonMarshaller, ProjectPermissionsHelper projectPermissionsHelper) {
        this.jiraAuthenticationContext = authenticationContext;
        this.darkFeatureManager = darkFeatureManager;
        this.shortcutsService = shortcutsService;
        this.pageBuilderService = pageBuilderService;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.projectPermissionsHelper = projectPermissionsHelper;
    }

    @Override
    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        ImmutableMap.Builder contextMap = ImmutableMap.builder();
        List shortcuts = this.shortcutsService.getShortcuts(project, this.jiraAuthenticationContext.getUser());
        boolean canManage = this.projectPermissionsHelper.canModifyShortcuts(project, this.jiraAuthenticationContext.getUser()).isEmpty();
        boolean isProjectShortcutIconsEnabled = this.darkFeatureManager.isFeatureEnabledForUser(this.jiraAuthenticationContext.getUser() != null ? new UserKey(this.jiraAuthenticationContext.getUser().getKey()) : null, "com.atlassian.jira.projects.ProjectCentricNavigation.ProjectShortcutIcons");
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.shortcuts:can-manage", Boolean.valueOf(canManage));
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.shortcuts:with-icons", Boolean.valueOf(isProjectShortcutIconsEnabled));
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.shortcuts:shortcuts", this.getShortcutsJsonable(shortcuts));
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.shortcuts:project-id", (Number)project.getId());
        contextMap.put((Object)"canManage", (Object)canManage);
        contextMap.put((Object)"shortcuts", (Object)shortcuts);
        contextMap.put((Object)"numberOfShortcuts", (Object)shortcuts.size());
        contextMap.put((Object)"isWithIcons", (Object)isProjectShortcutIconsEnabled);
        if (isProjectShortcutIconsEnabled) {
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.shortcuts:icons-list", this.getShortcutsIconsListJsonable((List<ProjectShortcutIcon>)ICONS_LIST));
            contextMap.put((Object)"iconsMap", this.getShortcutsIconsMap(ICONS_LIST));
        }
        return contextMap.build();
    }

    private Map<String, ProjectShortcutIcon> getShortcutsIconsMap(ImmutableList<ProjectShortcutIcon> shortcutsIcons) {
        return Maps.uniqueIndex(shortcutsIcons, (Function)new Function<ProjectShortcutIcon, String>(){

            public String apply(ProjectShortcutIcon input) {
                return input.getName();
            }
        });
    }

    private Jsonable getShortcutsJsonable(final List<ProjectShortcut> shortcuts) {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                writer.append(ShortcutsWebPanelContextProviderImpl.this.jaxbJsonMarshaller.marshal((Object)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)shortcuts, ShortcutsResource.SHORTCUT_TO_BEAN))));
            }
        };
    }

    private Jsonable getShortcutsIconsListJsonable(final List<ProjectShortcutIcon> shortcutIcons) {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                writer.append(ShortcutsWebPanelContextProviderImpl.this.jaxbJsonMarshaller.marshal((Object)shortcutIcons));
            }
        };
    }

    @XmlRootElement
    public static class ProjectShortcutIcon {
        @XmlElement
        private final String name;
        @XmlElement
        private final String className;

        public ProjectShortcutIcon(String name, String className) {
            this.name = name;
            this.className = className;
        }

        public ProjectShortcutIcon() {
            this.name = "";
            this.className = "";
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

