/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.shortcuts;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.projects.shortcuts.CachingShortcutsStore;
import com.atlassian.jira.projects.shortcuts.MutableProjectShortcut;
import com.atlassian.jira.projects.shortcuts.ProjectShortcut;
import com.atlassian.jira.projects.shortcuts.ShortcutsStore;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShortcutsManager {
    private static final Logger log = LoggerFactory.getLogger(ShortcutsManager.class);
    private final ShortcutsStore shortcutsStore;
    private final ProjectManager projectManager;

    @Autowired
    public ShortcutsManager(@ComponentImport ProjectManager projectManager, CachingShortcutsStore shortcutsStore) {
        this.projectManager = projectManager;
        this.shortcutsStore = shortcutsStore;
    }

    public List<ProjectShortcut> getShortcuts(Project project) {
        return this.shortcutsStore.getShortcuts(project.getId()).stream().map(mutableShortcut -> (ProjectShortcut)this.modelToShortcut().apply(mutableShortcut)).collect(Collectors.toList());
    }

    public synchronized Either<ErrorCollection, ProjectShortcut> addShortcut(ProjectShortcut shortcut) {
        try {
            MutableProjectShortcut mutableProjectShortcut = this.shortcutsStore.create(shortcut.getName(), shortcut.getUrl(), shortcut.getIcon(), shortcut.getProject().getId());
            return Either.right((Object)this.modelToShortcut().apply((Object)mutableProjectShortcut));
        }
        catch (RuntimeException e) {
            log.debug("Shortcut add caused Exception", (Throwable)e);
            return ShortcutsManager.wrapException(e);
        }
    }

    public Option<ProjectShortcut> getShortcut(Integer id) {
        return this.shortcutsStore.getShortcut((Integer)Preconditions.checkNotNull((Object)id)).map(this.modelToShortcut());
    }

    public synchronized Either<ErrorCollection, ProjectShortcut> updateShortcut(ProjectShortcut shortcutData) {
        try {
            Option<MutableProjectShortcut> updatedData = this.shortcutsStore.update(shortcutData.getId(), shortcutData.getName(), shortcutData.getUrl(), shortcutData.getIcon());
            if (updatedData.isEmpty()) {
                return ShortcutsManager.notFound();
            }
            return Either.right((Object)updatedData.map(this.modelToShortcut()).get());
        }
        catch (RuntimeException e) {
            log.debug("Shortcut update caused Exception", (Throwable)e);
            return ShortcutsManager.wrapException(e);
        }
    }

    public synchronized Either<ErrorCollection, ProjectShortcut> deleteShortcut(Integer id) {
        try {
            Preconditions.checkNotNull((Object)id);
            Option<MutableProjectShortcut> delete = this.shortcutsStore.delete(id);
            if (delete.isEmpty()) {
                return ShortcutsManager.notFound();
            }
            return Either.right((Object)delete.map(this.modelToShortcut()).get());
        }
        catch (RuntimeException e) {
            log.debug("Shortcut delete caused Exception", (Throwable)e);
            return ShortcutsManager.wrapException(e);
        }
    }

    private static Either<ErrorCollection, ProjectShortcut> notFound() {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        simpleErrorCollection.addErrorMessage("project.shortcuts.cannot.find.shortcut", ErrorCollection.Reason.NOT_FOUND);
        return Either.left((Object)simpleErrorCollection);
    }

    private static Either<ErrorCollection, ProjectShortcut> wrapException(Exception e) {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        if (e instanceof UndeclaredThrowableException) {
            simpleErrorCollection.addErrorMessage(((UndeclaredThrowableException)e).getUndeclaredThrowable().getMessage(), ErrorCollection.Reason.SERVER_ERROR);
        } else {
            simpleErrorCollection.addErrorMessage(e.getMessage(), ErrorCollection.Reason.SERVER_ERROR);
        }
        return Either.left((Object)simpleErrorCollection);
    }

    private Function<MutableProjectShortcut, ProjectShortcut> modelToShortcut() {
        return new Function<MutableProjectShortcut, ProjectShortcut>(){

            public ProjectShortcut apply(MutableProjectShortcut input) {
                return new ProjectShortcut(input.getId().intValue(), input.getName(), input.getShortcutUrl(), StringUtils.trimToEmpty((String)input.getIcon()), ShortcutsManager.this.projectManager.getProjectObj(input.getProjectId()));
            }
        };
    }
}

