/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status;

import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status.StatusCount;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class StatusCountToCategoryMapper {
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;

    @Autowired
    public StatusCountToCategoryMapper(@ComponentImport WorkflowSchemeManager workflowSchemeManager, @ComponentImport WorkflowManager workflowManager) {
        this.workflowSchemeManager = (WorkflowSchemeManager)Preconditions.checkNotNull((Object)workflowSchemeManager);
        this.workflowManager = (WorkflowManager)Preconditions.checkNotNull((Object)workflowManager);
    }

    public Map<StatusCategory, Set<StatusCount>> getStatusesInCategory(Project project, Map<Status, Long> statusesMappedToIssueCounts) {
        Map issueTypeToWorkflowMapping = this.workflowSchemeManager.getWorkflowMap(project);
        return issueTypeToWorkflowMapping.values().stream().distinct().map(arg_0 -> ((WorkflowManager)this.workflowManager).getWorkflow(arg_0)).map(JiraWorkflow::getLinkedStatusObjects).map(status -> this.statusCategoriesMappedToStatusCounts((List<Status>)status, statusesMappedToIssueCounts)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Sets::union));
    }

    private Map<StatusCategory, Set<StatusCount>> statusCategoriesMappedToStatusCounts(List<Status> statuses, Map<Status, Long> statusesMappedToIssueCounts) {
        return statuses.stream().map(status -> this.toStatusCount((Status)status, (Long)statusesMappedToIssueCounts.get(status))).collect(Collectors.groupingBy(statusCount -> statusCount.getStatus().getStatusCategory(), Collectors.toSet()));
    }

    private StatusCount toStatusCount(Status status, Long count) {
        return new StatusCount(status, count == null ? 0L : count);
    }
}

