/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.DataRequest;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.IssueCountAccessor;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.IssueMapperFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.StatisticAccessorBeanFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status.StatusCategoryCount;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status.StatusCount;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status.StatusCountToCategoryAggregator;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status.StatusCountToCategoryMapper;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status.StatusSummaryMathUtils;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class StatusCategoryCountService {
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final IssueCountAccessor issueCountAccessor;
    private final StatusCountToCategoryAggregator statusCountToCategoryAggregator;
    private final StatusCountToCategoryMapper statusCountToCategoryMapper;
    private final IssueMapperFactory<Status> mapperFactory;
    private final StatisticAccessorBeanFactory beanFactory;
    static final List<String> STATUS_CATEGORY_ORDERING = Lists.newArrayList((Object[])new String[]{"new", "indeterminate", "done", "undefined"});
    static final Comparator<StatusCategoryCount> statusCategoryCountComparator = (s1, s2) -> STATUS_CATEGORY_ORDERING.indexOf(s1.getKey()) - STATUS_CATEGORY_ORDERING.indexOf(s2.getKey());

    @Autowired
    public StatusCategoryCountService(@ComponentImport I18nHelper.BeanFactory i18nHelperFactory, IssueCountAccessor issueCountAccessor, StatusCountToCategoryAggregator statusCountToCategoryAggregator, StatusCountToCategoryMapper statusCountToCategoryMapper, IssueMapperFactory<Status> issueMapperFactory, StatisticAccessorBeanFactory beanFactory) {
        this.i18nHelperFactory = (I18nHelper.BeanFactory)Preconditions.checkNotNull((Object)i18nHelperFactory);
        this.issueCountAccessor = (IssueCountAccessor)Preconditions.checkNotNull((Object)issueCountAccessor);
        this.statusCountToCategoryAggregator = (StatusCountToCategoryAggregator)Preconditions.checkNotNull((Object)statusCountToCategoryAggregator);
        this.statusCountToCategoryMapper = (StatusCountToCategoryMapper)Preconditions.checkNotNull((Object)statusCountToCategoryMapper);
        this.mapperFactory = (IssueMapperFactory)Preconditions.checkNotNull(issueMapperFactory);
        this.beanFactory = (StatisticAccessorBeanFactory)Preconditions.checkNotNull((Object)beanFactory);
    }

    public List<StatusCategoryCount> getStatusCategoryCounts(DataRequest dataRequest) {
        Map<Status, Long> nonZeroIssueCountPerStatus = this.issueCountAccessor.getNonZeroIssueCount(this.beanFactory.createAccessorBeanForAllIssues(dataRequest), this.mapperFactory.getMapper());
        Map<StatusCategory, Long> issueCountPerStatusCategory = this.statusCountToCategoryAggregator.getIssueCountPerStatusCategory(nonZeroIssueCountPerStatus);
        long totalIssueCount = StatusSummaryMathUtils.sum(issueCountPerStatusCategory.values());
        ArrayList statusCategories = Lists.newArrayList(issueCountPerStatusCategory.keySet());
        I18nHelper i18nHelper = this.i18nHelperFactory.getInstance(dataRequest.getUser());
        Map<StatusCategory, Set<StatusCount>> statuses = this.statusCountToCategoryMapper.getStatusesInCategory(dataRequest.getProject(), nonZeroIssueCountPerStatus);
        return (List)statusCategories.stream().map(statusCategory -> this.toStatusCategoryCount((StatusCategory)statusCategory, issueCountPerStatusCategory, statuses, totalIssueCount, i18nHelper)).sorted(statusCategoryCountComparator).collect(CollectorsUtil.toImmutableList());
    }

    private StatusCategoryCount toStatusCategoryCount(StatusCategory statusCategory, Map<StatusCategory, Long> issueCountPerStatusCategory, Map<StatusCategory, Set<StatusCount>> statuses, long totalIssueCount, I18nHelper i18nHelper) {
        long count = issueCountPerStatusCategory.get(statusCategory);
        long roughPercentage = StatusSummaryMathUtils.getRoughPercentage(count, totalIssueCount);
        String translatedName = statusCategory.getTranslatedName(i18nHelper);
        return new StatusCategoryCount(statusCategory, translatedName, count, roughPercentage, (Collection<StatusCount>)statuses.get(statusCategory));
    }
}

