/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;

@Scanned
public class LeadContextProvider
extends AbstractProjectsPageContextProvider {
    private static final String PROFILE_LINK_USER_FORMAT_TYPE = "profileLinkWithAvatar";
    private final UserFormats userFormats;
    private final AvatarService avatarService;
    private final JiraAuthenticationContext authenticationContext;

    public LeadContextProvider(@ComponentImport UserFormats userFormats, @ComponentImport AvatarService avatarService, @ComponentImport JiraAuthenticationContext authenticationContext) {
        this.userFormats = userFormats;
        this.avatarService = avatarService;
        this.authenticationContext = authenticationContext;
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        ImmutableMap.Builder context = ImmutableMap.builder();
        if (project.getProjectLead() != null) {
            URI avatarURL = this.avatarService.getAvatarURL(this.authenticationContext.getUser(), project.getProjectLead(), Avatar.Size.NORMAL);
            String leadAvatarHTML = this.userFormats.formatter(PROFILE_LINK_USER_FORMAT_TYPE).formatUserkey(project.getProjectLead().getKey(), "project-vignette", (Map)ImmutableMap.of((Object)"avatarSize", (Object)Avatar.Size.NORMAL.getParam(), (Object)"avatarURL", (Object)avatarURL.toString()));
            context.put((Object)"leadHTML", (Object)leadAvatarHTML);
        }
        return context.build();
    }
}

