/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.report;

import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.plugin.report.ReportModuleDescriptorComparators;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportService {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public ReportService(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport PluginAccessor pluginAccessor) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.pluginAccessor = pluginAccessor;
    }

    public List<ReportModuleDescriptor> getReports(Map<String, Object> context) {
        Iterable visibleReports = Iterables.filter((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(ReportModuleDescriptor.class), this.satisfyModuleDescriptorConditionAndCanBeDisplayed(context));
        return Ordering.from((Comparator)new WeightedDescriptorComparator()).compound(ReportModuleDescriptorComparators.byName((Locale)this.jiraAuthenticationContext.getLocale())).immutableSortedCopy(visibleReports);
    }

    private Predicate<ReportModuleDescriptor> satisfyModuleDescriptorConditionAndCanBeDisplayed(final Map<String, Object> context) {
        return SafePluginPointAccess.safe((Predicate)new Predicate<ReportModuleDescriptor>(){

            public boolean apply(@Nullable ReportModuleDescriptor input) {
                boolean shouldShow = input.getModule().showReport();
                if (input instanceof ConditionalDescriptor) {
                    ConditionalDescriptor conditionalDescriptor = (ConditionalDescriptor)input;
                    Condition condition = conditionalDescriptor.getCondition();
                    return shouldShow && (condition == null || condition.shouldDisplay(context));
                }
                return shouldShow;
            }
        });
    }
}

