/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.release;

import com.atlassian.fugue.Option;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionService {
    private static final Logger log = Logger.getLogger(VersionService.class);
    private final VersionManager versionManager;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final com.atlassian.jira.projects.util.ProjectPermissions projectPermissions;

    @Autowired
    public VersionService(@ComponentImport VersionManager versionManager, @ComponentImport FieldVisibilityManager fieldVisibilityManager, @ComponentImport PermissionManager permissionManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, com.atlassian.jira.projects.util.ProjectPermissions projectPermissions) {
        this.versionManager = versionManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectPermissions = projectPermissions;
    }

    @VisibleForTesting
    boolean canViewVersions(Project project) {
        return this.projectPermissions.hasProjectAdminPermission(this.jiraAuthenticationContext.getLoggedInUser(), project) != false || this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, this.jiraAuthenticationContext.getLoggedInUser()) && !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(project.getId(), "fixVersions");
    }

    @VisibleForTesting
    boolean canUserViewArchivedVersions(Project project, ApplicationUser user) {
        return this.projectPermissions.hasProjectAdminPermission(user, project);
    }

    public Option<List<Version>> getUnarchivedVersions(Project project) {
        if (this.canViewVersions(project)) {
            try {
                ImmutableList lists = ImmutableList.copyOf((Collection)this.versionManager.getVersionsUnarchived(project.getId()));
                return Option.some((Object)lists.reverse());
            }
            catch (DataAccessException e) {
                log.warn((Object)("Could not retrieve versions for project: " + project), (Throwable)e);
            }
        }
        return Option.none();
    }

    public Option<List<Version>> getVersions(Project project) {
        if (this.canViewVersions(project)) {
            try {
                ImmutableList lists = ImmutableList.copyOf((Collection)this.versionManager.getVersions(project.getId(), this.canUserViewArchivedVersions(project, this.jiraAuthenticationContext.getLoggedInUser())));
                return Option.some((Object)lists.reverse());
            }
            catch (DataAccessException e) {
                log.warn((Object)("Could not retrieve versions for project: " + project), (Throwable)e);
            }
        }
        return Option.none();
    }

    public Option<List<Version>> getUnreleasedVersions(Project project) {
        if (this.canViewVersions(project)) {
            try {
                ImmutableList versions = ImmutableList.copyOf((Collection)this.versionManager.getVersionsUnreleased(project.getId(), false));
                return Option.some((Object)versions.reverse());
            }
            catch (DataAccessException e) {
                log.warn((Object)("Could not retrieve versions for project: " + project), (Throwable)e);
            }
        }
        return Option.none();
    }

    public Option<List<Version>> getReleasedVersions(Project project) {
        if (this.canViewVersions(project)) {
            try {
                ImmutableList versions = ImmutableList.copyOf((Collection)this.versionManager.getVersionsReleased(project.getId(), false));
                return Option.some((Object)versions.reverse());
            }
            catch (DataAccessException e) {
                log.warn((Object)("Could not retrieve versions for project: " + project), (Throwable)e);
            }
        }
        return Option.none();
    }

    public Option<Version> getVersion(Long versionId) {
        Option version = Option.option((Object)this.versionManager.getVersion(versionId));
        return version.filter(v -> this.canViewVersions(v.getProject()));
    }
}

