/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.release;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.page.release.VersionService;
import com.atlassian.jira.projects.page.release.VersionToVersionViewTransformer;
import com.atlassian.jira.projects.page.release.VersionView;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="project/{projectKey}/release")
public class ReleasePageResource {
    private static final Logger log = Logger.getLogger(ReleasePageResource.class);
    private final ProjectService projectService;
    private final VersionService versionService;
    private final VersionToVersionViewTransformer versionToVersionView;
    private static final JsonFactory JSON = new MappingJsonFactory();

    @Autowired
    public ReleasePageResource(ProjectService projectService, VersionService versionService, VersionToVersionViewTransformer versionToVersionView) {
        this.projectService = projectService;
        this.versionService = versionService;
        this.versionToVersionView = versionToVersionView;
    }

    @GET
    @Path(value="allversions")
    @AnonymousAllowed
    public Response getAllVersionsForProject(@PathParam(value="projectKey") String projectKey) {
        Either<ErrorCollection, Project> project = this.projectService.getProject(projectKey);
        if (project.isRight()) {
            StreamingOutput out = outputStream -> {
                try (JsonGenerator jsGen = JSON.createJsonGenerator(outputStream, JsonEncoding.UTF8);){
                    jsGen.writeStartArray();
                    jsGen.flush();
                    List versions = (List)this.versionService.getVersions((Project)project.right().get()).getOrElse((Object)ImmutableList.of());
                    for (VersionView view : Iterables.transform((Iterable)versions, (Function)this.versionToVersionView)) {
                        jsGen.writeObject((Object)view);
                    }
                    jsGen.writeEndArray();
                }
                catch (IOException e) {
                    log.warn((Object)String.format("Exception while streaming versions for project: %s", projectKey), (Throwable)e);
                }
            };
            return Response.ok((Object)out).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)((ErrorCollection)project.left().get()).getErrorMessages()).build();
    }

    @GET
    @Path(value="versions")
    @AnonymousAllowed
    public Response getVersionsForProject(@PathParam(value="projectKey") String projectKey) {
        Either<ErrorCollection, Project> project = this.projectService.getProject(projectKey);
        if (project.isRight()) {
            List versions = (List)this.versionService.getUnarchivedVersions((Project)project.right().get()).getOrElse((Object)ImmutableList.of());
            ImmutableList versionViews = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)versions, (Function)this.versionToVersionView));
            return Response.ok((Object)versionViews).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)((ErrorCollection)project.left().get()).getErrorMessages()).build();
    }

    @GET
    @Path(value="/details/{versionId}")
    @AnonymousAllowed
    public Response getDetails(@PathParam(value="versionId") Long versionId) {
        Option<Version> version = this.versionService.getVersion(versionId);
        if (version.isDefined()) {
            return Response.ok((Object)version.map((Function)this.versionToVersionView).get()).cacheControl(CacheControl.never()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

