/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.release;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatUtils;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.projects.page.release.ReleaseReportsService;
import com.atlassian.jira.projects.page.release.VersionsJsonableProvider;
import com.atlassian.jira.projects.util.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.util.CalendarResourceIncluder;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleasePageContextProvider
extends AbstractProjectsPageContextProvider {
    private static final String JIRA_PROJECT_RELEASE_CONTEXT = "jira.project.release";
    protected static final String RENDER_LEGACY = "renderLegacy";
    private final ProjectPermissions projectPermissions;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PageBuilderService pageBuilderService;
    private final HelpUrls urls;
    private final ReleaseReportsService releaseReportsService;
    private final VersionsJsonableProvider versionsJsonableProvider;
    private final FeatureManager featureManager;
    private final ApplicationProperties applicationProperties;
    private static final String RELEASE_PAGE_TITLE = "releaseTitle";
    @VisibleForTesting
    public static final String PROJECT_PAGE_RELEASE_TITLE_FOR_SOFTWARE = "project.page.release.title.for.software";
    @VisibleForTesting
    public static final String PROJECT_PAGE_RELEASE_TITLE = "project.page.release.title";

    @Autowired
    public ReleasePageContextProvider(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport HelpUrls urls, ProjectPermissions projectPermissions, @ComponentImport JiraPageBuilderService pageBuilderService, ReleaseReportsService releaseReportsService, VersionsJsonableProvider versionsJsonableProvider, FeatureManager featureManager, @ComponentImport ApplicationProperties applicationProperties) {
        this.projectPermissions = projectPermissions;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.pageBuilderService = pageBuilderService;
        this.urls = urls;
        this.releaseReportsService = releaseReportsService;
        this.versionsJsonableProvider = versionsJsonableProvider;
        this.featureManager = featureManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        Stream.of(JIRA_PROJECT_RELEASE_CONTEXT, "jira.project.sidebar").forEach(ctx -> this.pageBuilderService.assembler().resources().requireContext(ctx));
        this.includeRequiredPageData(project);
        this.includeWebResources();
        ImmutableMap.Builder contextMap = ImmutableMap.builder();
        this.addProjectAdminLink((ImmutableMap.Builder<String, Object>)contextMap, project);
        this.addReleaseReportCallToAction((ImmutableMap.Builder<String, Object>)contextMap, project);
        this.addReleaseTitle((ImmutableMap.Builder<String, Object>)contextMap, project);
        if (originalContext.containsKey(RENDER_LEGACY)) {
            contextMap.put((Object)RENDER_LEGACY, originalContext.get(RENDER_LEGACY));
        }
        return contextMap.build();
    }

    private void includeWebResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.jira-projects-plugin:release-page-init");
    }

    private void addReleaseTitle(ImmutableMap.Builder<String, Object> contextMap, Project project) {
        if (this.isSoftwareProject(project)) {
            contextMap.put((Object)RELEASE_PAGE_TITLE, (Object)this.jiraAuthenticationContext.getI18nHelper().getText(PROJECT_PAGE_RELEASE_TITLE_FOR_SOFTWARE));
        } else {
            contextMap.put((Object)RELEASE_PAGE_TITLE, (Object)this.jiraAuthenticationContext.getI18nHelper().getText(PROJECT_PAGE_RELEASE_TITLE));
        }
    }

    private void includeRequiredPageData(Project project) {
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.page.release:learnMoreUrl", this.urls.getUrl("version_management").getUrl());
        boolean isProjectAdmin = this.projectPermissions.hasProjectAdminPermission(this.jiraAuthenticationContext.getLoggedInUser(), project);
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.page.release:projectAdmin", Boolean.valueOf(isProjectAdmin));
        this.includeCalendarParameters();
        Locale locale = this.jiraAuthenticationContext.getI18nHelper().getLocale();
        CalendarResourceIncluder calendarResourceIncluder = new CalendarResourceIncluder();
        calendarResourceIncluder.includeForLocale(locale);
    }

    public void includeCalendarParameters() {
        Calendar calendar = Calendar.getInstance(this.jiraAuthenticationContext.getLocale());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"singleClick", (Object)true).put((Object)"align", (Object)"Bl").put((Object)"firstDay", (Object)(calendar.getFirstDayOfWeek() - 1)).put((Object)"currentMillis", (Object)System.currentTimeMillis()).put((Object)"useISO8601WeekNumbers", (Object)this.applicationProperties.getOption("jira.date.time.picker.use.iso8061")).put((Object)"ifFormat", (Object)DateTimeFormatUtils.getDateFormat()).put((Object)"dateFormat", (Object)this.applicationProperties.getDefaultBackedString("jira.date.picker.java.format"));
        this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.projects.page.release:calendarParams", writer -> {
            try {
                new JSONObject((Map)builder.build()).write(writer);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void addProjectAdminLink(ImmutableMap.Builder<String, Object> builder, Project project) {
        if (this.projectPermissions.hasProjectAdminPermission(this.jiraAuthenticationContext.getLoggedInUser(), project).booleanValue()) {
            builder.put((Object)"adminLink", (Object)("plugins/servlet/project-config/" + URLEncoder.encodePathSegment(project.getKey()) + "/versions"));
        }
    }

    private void addReleaseReportCallToAction(ImmutableMap.Builder<String, Object> builder, Project project) {
        if (this.isSoftwareProject(project) && !this.releaseReportsService.hasBeenVisitedByCurrentUser()) {
            builder.put((Object)"learnMoreURL", (Object)this.urls.getUrl("releases.whats.new.learn.more").getUrl());
            builder.put((Object)"learnMoreTitle", (Object)this.urls.getUrl("releases.whats.new.learn.more").getTitle());
        }
    }

    private boolean isSoftwareProject(Project project) {
        return project.getProjectTypeKey().equals((Object)new ProjectTypeKey("software"));
    }
}

