/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.release;

import com.atlassian.fugue.Option;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTab;
import com.atlassian.jira.projectconfig.tab.ProjectConfigTabRenderContext;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.util.WebPanelRenderer;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ProjectConfigTab.class})
public class AdministerVersions
implements ProjectConfigTab {
    private static final Logger log = LoggerFactory.getLogger(AdministerVersions.class);
    private static final String RESOURCE_KEY = "com.atlassian.jira.jira-projects-plugin:release-page";
    private final WebPanelRenderer webPanelRenderer;
    private final ProjectContextPopulator projectContextPopulator;

    @Autowired
    public AdministerVersions(WebPanelRenderer webPanelRenderer, ProjectContextPopulator projectContextPopulator) {
        this.webPanelRenderer = webPanelRenderer;
        this.projectContextPopulator = projectContextPopulator;
    }

    public String getId() {
        return "administer-versions";
    }

    public String getLinkId() {
        return "administer_project_versions";
    }

    public String getTab(ProjectConfigTabRenderContext context) {
        Map renderContext = this.projectContextPopulator.populateWithProject(context.getProject());
        renderContext.put("renderLegacy", true);
        Option<String> renderedPanels = this.webPanelRenderer.renderWebPanels(RESOURCE_KEY, renderContext);
        if (renderedPanels.isDefined()) {
            return (String)renderedPanels.get();
        }
        log.warn(String.format("Couldn't render %s WebPanel", RESOURCE_KEY));
        return "";
    }

    public String getTitle(ProjectConfigTabRenderContext context) {
        return context.getI18NHelper().getText("common.concepts.versions");
    }

    public void addResourceForProject(ProjectConfigTabRenderContext context) {
    }
}

