/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.components;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AssigneeSelectContextProvider {
    private final I18nHelper i18nHelper;

    @Autowired
    public AssigneeSelectContextProvider(@ComponentImport I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public Map<String, Object> getParameters(Project project) {
        return ImmutableMap.builder().put((Object)"leadDisplayableName", (Object)(project != null ? this.getDisplayableUserName(project.getProjectLead()) : "")).put((Object)"isDefaultAssigneeProjectLead", project != null ? Boolean.valueOf(this.isDefaultAssigneeProjectLead(project)) : "").build();
    }

    private String getDisplayableUserName(ApplicationUser user) {
        return Optional.ofNullable(user).map(ApplicationUser::getDisplayName).orElse(this.i18nHelper.getText("project.page.components.add.assignee.unassigned"));
    }

    private boolean isDefaultAssigneeProjectLead(Project project) {
        return ProjectAssigneeTypes.isProjectLead((Long)project.getAssigneeType());
    }
}

