/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.api.sidebar.ProjectSidebarRenderer;
import com.atlassian.jira.projects.compatibility.AtlassianConnect;
import com.atlassian.jira.projects.legacy.page.ActionContextService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.HttpServletVariables;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.data.PluginDataResource;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="sidebar")
@Scanned
public class SidebarResource {
    private static final String SUMMARY_PAGE_KEY = "com.atlassian.jira.jira-projects-plugin:summary-page";
    private static final String COMPLETE_KEY_SEPARATOR = ":";
    public static final Pattern PROJECTKEY_FROM_ISSUEKEY_PATTERN = Pattern.compile("(.*)-\\d+$");
    private final ProjectService projectService;
    private final ActionContextService actionContextService;
    private final ProjectSidebarRenderer projectSidebarRenderer;
    private final JiraPageBuilderService jiraPageBuilderService;
    private final HttpServletVariables httpServletVariables;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public SidebarResource(ActionContextService actionContextService, ProjectService projectService, ProjectSidebarRenderer projectSidebarRenderer, @ComponentImport JiraPageBuilderService jiraPageBuilderService, @ComponentImport HttpServletVariables httpServletVariables, @ComponentImport PermissionManager permissionManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext) {
        this.actionContextService = actionContextService;
        this.projectService = projectService;
        this.projectSidebarRenderer = projectSidebarRenderer;
        this.jiraPageBuilderService = jiraPageBuilderService;
        this.httpServletVariables = httpServletVariables;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/project/{projectKey}")
    @Produces(value={"application/json"})
    public Response getSidebarByProject(@PathParam(value="projectKey") String projectKey, @DefaultValue(value="com.atlassian.jira.jira-projects-plugin:summary-page") @QueryParam(value="selectedItem") String selectedItem) {
        this.actionContextService.setActiveRequestForBackwardsCompatibility(this.httpServletVariables.getHttpRequest());
        try {
            Response response = this.getResponse(projectKey, selectedItem);
            return response;
        }
        finally {
            this.actionContextService.clearActiveRequestForWebworkActionCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/issue/{issueKey}")
    @Produces(value={"application/json"})
    public Response getSidebarByIssue(@PathParam(value="issueKey") String issueKey, @DefaultValue(value="com.atlassian.jira.jira-projects-plugin:summary-page") @QueryParam(value="selectedItem") String selectedItem) {
        this.actionContextService.setActiveRequestForBackwardsCompatibility(this.httpServletVariables.getHttpRequest());
        try {
            Optional<String> projectKey = Optional.of(PROJECTKEY_FROM_ISSUEKEY_PATTERN).map(pattern -> pattern.matcher(issueKey)).filter(Matcher::find).map(matcher -> matcher.group(1));
            if (!projectKey.isPresent()) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            Response response = this.getResponse(projectKey.get(), selectedItem);
            return response;
        }
        finally {
            this.actionContextService.clearActiveRequestForWebworkActionCleanup();
        }
    }

    private Response getResponse(String projectKey, String selectedItem) {
        Optional<Project> project = Optional.of(projectKey).map(this.projectService::getProject).filter(Either::isRight).map(either -> either.right()).map(Either.RightProjection::get);
        if (!project.filter(projectObj -> ProjectAction.VIEW_PROJECT.hasPermission(this.permissionManager, this.jiraAuthenticationContext.getLoggedInUser(), projectObj)).isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String checkedSelectedItem = selectedItem;
        if (!checkedSelectedItem.contains(COMPLETE_KEY_SEPARATOR)) {
            checkedSelectedItem = AtlassianConnect.prefixConnectModuleKey(selectedItem);
        }
        this.jiraPageBuilderService.assembler().assembled().drainIncludedResources();
        String sidebarHtml = this.projectSidebarRenderer.render(project.get(), checkedSelectedItem);
        WebResourceSet resources = this.jiraPageBuilderService.assembler().assembled().drainIncludedResources();
        Map<String, String> data = StreamSupport.stream(resources.getResources(PluginDataResource.class).spliterator(), false).filter(resource -> resource.getData().isPresent()).collect(Collectors.toMap(PluginDataResource::getKey, resource -> {
            Jsonable jsonable = (Jsonable)resource.getData().get();
            StringWriter buf = new StringWriter();
            try {
                jsonable.write((Writer)buf);
            }
            catch (IOException e) {
                throw new RuntimeException("Can't serialize Jsonable", e);
            }
            return buf.toString();
        }));
        return Response.ok((Object)new SidebarResourceResponse(sidebarHtml, data)).build();
    }

    @VisibleForTesting
    public static final class SidebarResourceResponse {
        private final String html;
        private final Map<String, String> data;

        public SidebarResourceResponse(String html, Map<String, String> data) {
            this.html = html;
            this.data = data;
        }

        @JsonProperty
        public String getHtml() {
            return this.html;
        }

        @JsonProperty
        public Map<String, String> getData() {
            return this.data;
        }
    }
}

