/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page;

import com.atlassian.fugue.Option;
import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.compatibility.AtlassianConnect;
import com.atlassian.jira.projects.page.ProjectPanel;
import com.atlassian.jira.projects.util.WebPanelRenderer;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectWebPanelRenderer {
    private static final String TAB_PANEL_LOCATION = "jira.project.tab.panel.web.panel";
    private final WebPanelRenderer webPanelRenderer;
    private final ProjectContextPopulator contextPopulator;

    @Autowired
    public ProjectWebPanelRenderer(WebPanelRenderer webPanelRenderer, ProjectContextPopulator contextPopulator) {
        this.webPanelRenderer = webPanelRenderer;
        this.contextPopulator = contextPopulator;
    }

    public Option<ProjectPanel> render(Project project, String webItemCompleteKey) {
        Option<String> renderWebPanelsResult = this.renderWebPanels(project, webItemCompleteKey);
        if (renderWebPanelsResult.isDefined()) {
            return renderWebPanelsResult.map(content -> new ProjectPanel((String)content, ProjectPanel.PanelType.WEB_PANEL));
        }
        return this.renderTabPanels(project, webItemCompleteKey).map(content -> new ProjectPanel((String)content, ProjectPanel.PanelType.TAB_PANEL));
    }

    private Map<String, Object> makeContext(Project project) {
        HashMap base = Maps.newHashMap((Map)DefaultWebFragmentContext.get());
        Map context = this.contextPopulator.populateWithProject((Map)base, project);
        return context;
    }

    private Option<String> renderTabPanels(Project project, String webItemCompleteKey) {
        Map<String, Object> context = this.makeContext(project);
        context.put("tabPanelKey", webItemCompleteKey);
        return this.webPanelRenderer.renderWebPanels(TAB_PANEL_LOCATION, context);
    }

    private Option<String> renderWebPanels(Project project, String webItemCompleteKey) {
        Map<String, Object> context = this.makeContext(project);
        return this.webPanelRenderer.renderWebPanels(AtlassianConnect.removeConnectPluginPrefix(webItemCompleteKey), context);
    }
}

