/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.api.sidebar.ProjectSidebarRenderer;
import com.atlassian.jira.projects.compatibility.AtlassianConnect;
import com.atlassian.jira.projects.legacy.page.ActionContextService;
import com.atlassian.jira.projects.page.ProjectPageRenderer;
import com.atlassian.jira.projects.servlet.ProjectPageErrorHandler;
import com.atlassian.jira.projects.sidebar.lastvisited.LastVisitedItemInProjectService;
import com.atlassian.jira.projects.util.FlushHeadEarlyService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.webresource.api.assembler.RequiredResources;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

@Scanned
public class ProjectPageServlet
extends HttpServlet {
    public static final String SUMMARY_PAGE_KEY = "com.atlassian.jira.jira-projects-plugin:summary-page";
    public static final String DEFAULT_PAGE_LOCATION = "jira.project.navigation.defaultpage";
    private static final String BROWSE_CONTEXT = "jira.browse.project";
    private static final String ERROR_PAGE_WEB_RESOURCE_KEY = "com.atlassian.jira.jira-projects-plugin:project-error-page";
    private static final String COMPLETE_KEY_SEPARATOR = ":";
    private static final String CONTENT_ONLY_PARAM = "contentOnly";
    private final JiraPageBuilderService jiraPageBuilderService;
    private final ProjectPageErrorHandler projectPageErrorHandler;
    private final ProjectPageRenderer projectPageRenderer;
    private final ProjectService projectService;
    private final ActionContextService actionContextService;
    private final ProjectContextPopulator contextPopulator;
    private final LastVisitedItemInProjectService lastVisitedItemInProjectService;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final MauEventService mauEventService;
    private final ProjectSidebarRenderer projectSidebarRenderer;
    private final FlushHeadEarlyService flushHeadEarlyService;

    public ProjectPageServlet(ActionContextService actionContextService, @ComponentImport JiraPageBuilderService jiraPageBuilderService, ProjectPageErrorHandler projectPageErrorHandler, ProjectPageRenderer projectPageRenderer, ProjectService projectService, ProjectContextPopulator contextPopulator, LastVisitedItemInProjectService lastVisitedItemInProjectService, @ComponentImport DynamicWebInterfaceManager webInterfaceManager, @ComponentImport MauEventService mauEventService, ProjectSidebarRenderer projectSidebarRenderer, FlushHeadEarlyService flushHeadEarlyService) {
        this.actionContextService = actionContextService;
        this.jiraPageBuilderService = jiraPageBuilderService;
        this.projectPageErrorHandler = projectPageErrorHandler;
        this.projectPageRenderer = projectPageRenderer;
        this.projectService = projectService;
        this.contextPopulator = contextPopulator;
        this.lastVisitedItemInProjectService = lastVisitedItemInProjectService;
        this.webInterfaceManager = webInterfaceManager;
        this.mauEventService = mauEventService;
        this.projectSidebarRenderer = projectSidebarRenderer;
        this.flushHeadEarlyService = flushHeadEarlyService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.actionContextService.setActiveRequestForBackwardsCompatibility(request);
            Either<ErrorCollection, Project> getProjectResult = this.projectService.getProject(ProjectPageServlet.decodeProjectKeyFromPath(StringUtils.split((String)request.getPathInfo(), (String)"/")[1]));
            if (getProjectResult.isLeft()) {
                this.jiraPageBuilderService.assembler().resources().requireWebResource(ERROR_PAGE_WEB_RESOURCE_KEY);
                this.projectPageErrorHandler.writeErrorResponse((ErrorCollection)getProjectResult.left().get(), (Option<String>)Option.none(), request, response);
                return;
            }
            Project project = (Project)getProjectResult.right().get();
            this.mauEventService.setApplicationForThreadBasedOnProject(project);
            Either<String, String> selectedItem = this.selectItemToRender(project, request);
            if (selectedItem.isLeft()) {
                this.actionContextService.clearActiveRequestForWebworkActionCleanup();
                response.sendRedirect((String)selectedItem.left().get());
                return;
            }
            JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)response);
            this.renderItem((String)selectedItem.right().get(), project, request, response);
        }
        finally {
            this.actionContextService.clearActiveRequestForWebworkActionCleanup();
        }
    }

    private Either<String, String> selectItemToRender(Project project, HttpServletRequest request) {
        Option<String> selectedItem = ProjectPageServlet.getSelectedItemFromRequest(request);
        if (selectedItem.isDefined()) {
            return Either.right((Object)selectedItem.get());
        }
        Optional<String> lastVisitedUrl = this.getLastVisitedItemUrl(project);
        if (lastVisitedUrl.isPresent()) {
            return Either.left((Object)lastVisitedUrl.get());
        }
        Option<String> shouldRedirect = this.getPluginProvidedDefaultPage(request, project);
        if (shouldRedirect.isDefined()) {
            return Either.left((Object)shouldRedirect.get());
        }
        return Either.right((Object)SUMMARY_PAGE_KEY);
    }

    private void renderItem(String item, Project project, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Either<ErrorCollection, String> renderResult;
        if (SUMMARY_PAGE_KEY.equals(item)) {
            this.lastVisitedItemInProjectService.setLastVisitedItemIdForProject(project, item);
        }
        RequiredResources requiredResources = this.jiraPageBuilderService.assembler().resources();
        boolean flushHeadEarly = this.flushHeadEarlyService.isFlushHeadEarly();
        if (flushHeadEarly) {
            this.projectSidebarRenderer.requireResources(project, item);
            this.flushHeadEarlyService.requireResourcesOfItem(item);
            requiredResources.requireContext(BROWSE_CONTEXT);
            this.flushHeadEarlyService.flush();
        }
        if ((renderResult = this.getRenderResult(request, project, item)).isRight()) {
            if (!flushHeadEarly) {
                requiredResources.requireContext(BROWSE_CONTEXT);
            }
            response.getWriter().print((String)renderResult.right().get());
        } else {
            requiredResources.requireWebResource(ERROR_PAGE_WEB_RESOURCE_KEY);
            this.projectPageErrorHandler.writeErrorResponse((ErrorCollection)renderResult.left().get(), (Option<String>)Option.some((Object)project.getKey()), request, response);
        }
    }

    private Either<ErrorCollection, String> getRenderResult(HttpServletRequest request, Project project, String item) {
        if ("true".equals(request.getParameter(CONTENT_ONLY_PARAM))) {
            return this.projectPageRenderer.renderWithoutSidebar(project.getKey(), item);
        }
        return this.projectPageRenderer.renderWithSidebar(project.getKey(), item);
    }

    private Option<String> getPluginProvidedDefaultPage(HttpServletRequest request, Project project) {
        Map context = this.contextPopulator.populateWithProject(project);
        context.put("request", request);
        Option pluginProvidedDefaultPage = Iterables.first((Iterable)this.webInterfaceManager.getDisplayableWebItems(DEFAULT_PAGE_LOCATION, context));
        if (!pluginProvidedDefaultPage.isDefined()) {
            return Option.none();
        }
        return SafePluginPointAccess.call(() -> ((WebItem)pluginProvidedDefaultPage.get()).getUrl());
    }

    private Optional<String> getLastVisitedItemUrl(Project project) {
        return this.lastVisitedItemInProjectService.getLastVisitedItemUrl(project);
    }

    private static String decodeProjectKeyFromPath(String pathEncodedKey) {
        return JiraUrlCodec.decode((String)pathEncodedKey.replaceAll("\\+", "%2B"), (String)"UTF-8");
    }

    private static Option<String> getSelectedItemFromRequest(HttpServletRequest request) {
        String selectedItem = request.getParameter("selectedItem");
        if (StringUtils.isNotBlank((CharSequence)selectedItem)) {
            if (selectedItem.contains(COMPLETE_KEY_SEPARATOR)) {
                return Option.some((Object)selectedItem);
            }
            return Option.some((Object)AtlassianConnect.prefixConnectModuleKey(selectedItem));
        }
        String atlassianConnectItem = request.getParameter("acItem");
        if (StringUtils.isNotBlank((CharSequence)atlassianConnectItem)) {
            return Option.some((Object)AtlassianConnect.prefixConnectModuleKey(atlassianConnectItem));
        }
        return Option.none();
    }
}

