/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractUnresolvedIssuesFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractUrlFragmentUtil;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.JqlFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.StatisticAccessorBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SortOrder;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;

@Named
public class UnresolvedIssuesByAssigneeFragment
extends AbstractUnresolvedIssuesFragment
implements ProjectTabPanelFragment {
    private static final Logger log = Logger.getLogger(UnresolvedIssuesByAssigneeFragment.class);
    private final ApplicationProperties applicationProperties;
    private final UserFormatManager userFormatManager;

    @Inject
    public UnresolvedIssuesByAssigneeFragment(@ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport UserFormatManager userFormatManager, @ComponentImport FieldVisibilityManager fieldVisibilityManager, StatisticAccessorBeanFactory accessorBeanFactory, JqlFactory jqlFactory) {
        super(templatingEngine, jiraAuthenticationContext, fieldVisibilityManager, accessorBeanFactory, jqlFactory);
        this.applicationProperties = applicationProperties;
        this.userFormatManager = userFormatManager;
    }

    @Override
    public String getId() {
        return "unresolvedissuesbyassignee";
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("userFormatter", this.userFormatManager.getUserFormatter("fullName"));
        StatisticMapWrapper assignees = this.getAssignees(ctx);
        velocityParams.put("assignees", assignees);
        velocityParams.put("urlUtil", new AssigneeUrlUtil(this.getSearchRequest(ctx), this.authenticationContext.getLoggedInUser(), this.applicationProperties));
        return velocityParams;
    }

    @Override
    String getIssueFieldConstant() {
        return "assignee";
    }

    StatisticMapWrapper getAssignees(BrowseContext ctx) {
        try {
            return this.getStatsBean(ctx).getAllFilterBy("assignees");
        }
        catch (SearchException e) {
            log.error((Object)("Could not search for assignees in project '" + ctx.getProject().getKey() + "'"), (Throwable)e);
            return null;
        }
    }

    public static class AssigneeUrlUtil
    extends AbstractUrlFragmentUtil<ApplicationUser> {
        public AssigneeUrlUtil(SearchRequest searchRequest, ApplicationUser user, ApplicationProperties applicationProperties) {
            super(searchRequest, user, applicationProperties);
        }

        @Override
        protected Clause getDomainClause(ApplicationUser user) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            if (user != null) {
                builder.assignee().eq(user.getName());
            } else {
                builder.assigneeIsEmpty();
            }
            return builder.buildClause();
        }

        @Override
        protected OrderBy getOrderBy() {
            JqlOrderByBuilder jqlOrderByBuilder = JqlQueryBuilder.newOrderByBuilder();
            jqlOrderByBuilder.assignee(SortOrder.ASC);
            return jqlOrderByBuilder.buildOrderBy();
        }
    }
}

