/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractMultiFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractUrlFragmentUtil;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SortOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;

@Named
public class StatusSummaryFragment
extends AbstractMultiFragment {
    private static final Logger log = Logger.getLogger(StatusSummaryFragment.class);
    private static final String TEMPLATE_DIRECTORY_PATH = "legacy/templates/projectpanels/fragments/issues/";
    private final ApplicationProperties applicationProperties;

    @Inject
    public StatusSummaryFragment(@ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext) {
        super(templatingEngine, jiraAuthenticationContext);
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getId() {
        return "statussummary";
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("statuses", this.getStatuses(ctx));
        velocityParams.put("urlUtil", new StatusUrlUtil(this.getSearchRequest(ctx), this.authenticationContext.getLoggedInUser(), this.applicationProperties));
        return velocityParams;
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return true;
    }

    StatisticMapWrapper getStatuses(BrowseContext ctx) {
        try {
            StatisticMapWrapper map = this.getStatsBean(ctx).getAllFilterBy("statuses");
            this.transformStatisticMapWrapper(map);
            return map;
        }
        catch (SearchException e) {
            log.error((Object)("Could not search for priorities in project '" + ctx.getProject().getKey() + "'"), (Throwable)e);
            return null;
        }
    }

    StatisticAccessorBean getStatsBean(BrowseContext ctx) {
        return new StatisticAccessorBean(ctx.getUser(), this.getSearchRequest(ctx));
    }

    SearchRequest getSearchRequest(BrowseContext ctx) {
        Query initialQuery = ctx.createQuery();
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)initialQuery);
        builder.orderBy().priority(SortOrder.DESC, true);
        return new SearchRequest(builder.buildQuery());
    }

    private void transformStatisticMapWrapper(StatisticMapWrapper map) {
        LinkedHashMap<Status, Integer> priorityMap = new LinkedHashMap<Status, Integer>(map.size());
        for (Object o : map.entrySet()) {
            Map.Entry entry = (Map.Entry)o;
            Status status = (Status)entry.getKey();
            priorityMap.put(status, (Integer)entry.getValue());
        }
        map.setStatistics(priorityMap);
    }

    public static class StatusUrlUtil
    extends AbstractUrlFragmentUtil<Status> {
        public StatusUrlUtil(SearchRequest searchRequest, ApplicationUser user, ApplicationProperties applicationProperties) {
            super(searchRequest, user, applicationProperties);
        }

        @Override
        protected Clause getDomainClause(Status domain) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            builder.status().eq(domain.getName());
            return builder.buildClause();
        }

        @Override
        protected OrderBy getOrderBy() {
            JqlOrderByBuilder jqlOrderByBuilder = JqlQueryBuilder.newOrderByBuilder();
            jqlOrderByBuilder.status(SortOrder.DESC);
            return jqlOrderByBuilder.buildOrderBy();
        }
    }
}

