/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ProjectGetStarted
extends AbstractFragment {
    private static final String TEMPLATE_DIRECTORY_PATH = "legacy/templates/projectpanels/fragments/summary/";
    private static final String ID = "projectgetstarted";
    private final PermissionManager permissionManager;

    @Inject
    public ProjectGetStarted(@ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager) {
        super(templatingEngine, authenticationContext);
        this.permissionManager = permissionManager;
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        Project project = ctx.getProject();
        ApplicationUser user = this.authenticationContext.getUser();
        return project != null && this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, user) && this.getIssueCountInSearch(ctx) == 0L;
    }
}

