/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.projects.util.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ProjectDescriptionFragment
extends AbstractFragment {
    private static final String TEMPLATE_DIRECTORY_PATH = "legacy/templates/projectpanels/fragments/summary/";
    static final String CONTEXT_PROJECT_DESCRIPTION_RENDERER_KEY = "projectDescriptionRenderer";
    private final UserFormatManager userFormatManager;
    private final ProjectDescriptionRenderer projectDescriptionRenderer;
    private final ProjectPermissions projectPermissions;

    @Inject
    public ProjectDescriptionFragment(ProjectPermissions projectPermissions, @ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport UserFormatManager userFormatManager, @ComponentImport ProjectDescriptionRenderer projectDescriptionRenderer) {
        super(templatingEngine, jiraAuthenticationContext);
        this.userFormatManager = userFormatManager;
        this.projectDescriptionRenderer = projectDescriptionRenderer;
        this.projectPermissions = projectPermissions;
    }

    @Override
    public String getId() {
        return "projectdescription";
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Project project = ctx.getProject();
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("userFormat", this.userFormatManager.getUserFormat("profileLink"));
        velocityParams.put("leadExists", UserUtils.userExists((String)ctx.getProject().getLeadUserName()));
        velocityParams.put("hasAdminPermission", this.projectPermissions.hasProjectAdminPermission(this.authenticationContext.getLoggedInUser(), project));
        velocityParams.put(CONTEXT_PROJECT_DESCRIPTION_RENDERER_KEY, this.projectDescriptionRenderer);
        return velocityParams;
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return true;
    }
}

