/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.legacy.LegacyBrowseProjectUrlComponents;
import com.atlassian.jira.projects.legacy.LegacyBrowseProjectUrlTransformer;
import com.atlassian.jira.projects.legacy.LegacyProjectUrlComponentsExtractor;
import com.atlassian.jira.projects.legacy.LegacyUrlTransformerModuleDescriptor;
import com.atlassian.jira.projects.servlet.ProjectNotFoundPageRenderer;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.PluginAccessor;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LegacyRedirectFilter
extends AbstractHttpFilter {
    private final LegacyBrowseProjectUrlTransformer defaultTransformer;
    private final ProjectNotFoundPageRenderer notFoundPageRenderer;
    private final LegacyProjectUrlComponentsExtractor urlComponentsExtractor;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public LegacyRedirectFilter(LegacyBrowseProjectUrlTransformer defaultTransformer, ProjectNotFoundPageRenderer notFoundPageRenderer, LegacyProjectUrlComponentsExtractor urlComponentsExtractor, PluginAccessor pluginAccessor) {
        this.defaultTransformer = defaultTransformer;
        this.notFoundPageRenderer = notFoundPageRenderer;
        this.urlComponentsExtractor = urlComponentsExtractor;
        this.pluginAccessor = pluginAccessor;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Either<ErrorCollection, LegacyBrowseProjectUrlComponents> componentsResult = this.urlComponentsExtractor.extractComponents((String)StringUtils.defaultIfBlank((CharSequence)request.getContextPath(), (CharSequence)"/"), request.getServletPath(), request.getParameterMap());
        if (componentsResult.isLeft()) {
            this.handleErrorExtractingUrlComponents((ErrorCollection)componentsResult.left().get(), request, response, filterChain);
            return;
        }
        LegacyBrowseProjectUrlComponents urlComponents = (LegacyBrowseProjectUrlComponents)componentsResult.right().get();
        List<LegacyBrowseProjectUrlTransformer> transformers = this.getUrlTransformers();
        for (LegacyBrowseProjectUrlTransformer transformer : transformers) {
            Option transformedUrl = transformer.getTransformedUrl(urlComponents);
            if (!transformedUrl.isDefined()) continue;
            response.sendRedirect((String)transformedUrl.get());
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void handleErrorExtractingUrlComponents(ErrorCollection errorCollection, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Set reasons = errorCollection.getReasons();
        if (reasons.contains(ErrorCollection.Reason.NOT_FOUND)) {
            response.getWriter().append(this.notFoundPageRenderer.renderProjectNotFound());
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private List<LegacyBrowseProjectUrlTransformer> getUrlTransformers() {
        List<LegacyBrowseProjectUrlTransformer> transformers = this.getPluginProvidedUrlTransformers();
        transformers.add(this.defaultTransformer);
        return transformers;
    }

    private List<LegacyBrowseProjectUrlTransformer> getPluginProvidedUrlTransformers() {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(LegacyUrlTransformerModuleDescriptor.class);
        return moduleDescriptors.stream().map(LegacyUrlTransformerModuleDescriptor::getModule).collect(Collectors.toList());
    }
}

