/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.legacy.LegacyBrowseProjectUrlComponents;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LegacyProjectUrlComponentsExtractor {
    private static final String SELECTED_TAB_PARAM = "selectedTab";
    private final ProjectService projectService;
    private final UserProjectHistoryManager userProjectHistoryManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public LegacyProjectUrlComponentsExtractor(ProjectService projectService, @ComponentImport UserProjectHistoryManager userProjectHistoryManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext) {
        this.projectService = projectService;
        this.userProjectHistoryManager = userProjectHistoryManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public Either<ErrorCollection, LegacyBrowseProjectUrlComponents> extractComponents(String contextPath, String legacyProjectUrlPath, Map<String, String[]> urlParameters) {
        if (LegacyProjectUrlComponentsExtractor.isLegacyBrowseActionRequest(legacyProjectUrlPath)) {
            return this.extractComponentsForLegacyBrowseActionRequest(contextPath, urlParameters);
        }
        return this.extractComponentsForBrowseProjectRequest(contextPath, legacyProjectUrlPath, urlParameters);
    }

    private Either<ErrorCollection, LegacyBrowseProjectUrlComponents> extractComponentsForLegacyBrowseActionRequest(String contextPath, Map<String, String[]> urlParameters) {
        Option<String> projectKey = urlParameters.get("id") == null || urlParameters.get("id").length < 1 ? this.extractProjectKeyFromUserCurrentProject() : this.extractProjectKeyGivenProjectId(Long.parseLong(urlParameters.get("id")[0]));
        if (projectKey.isEmpty()) {
            return LegacyProjectUrlComponentsExtractor.error(ErrorCollection.Reason.NOT_FOUND);
        }
        return Either.right((Object)new LegacyBrowseProjectUrlComponents(contextPath, (String)projectKey.get(), this.extractSelectedTabFrom(urlParameters), Collections.emptyList(), this.extractQueryStringParams(urlParameters)));
    }

    private Either<ErrorCollection, LegacyBrowseProjectUrlComponents> extractComponentsForBrowseProjectRequest(String contextPath, String urlPath, Map<String, String[]> urlParameters) {
        ArrayList pathSegments = Lists.newArrayList((Object[])StringUtils.split((String)urlPath, (String)"/"));
        List<String> trailingSegments = pathSegments.subList(2, pathSegments.size());
        String key = (String)pathSegments.get(1);
        if (!JiraKeyUtils.validProjectKey((String)key) || LegacyProjectUrlComponentsExtractor.isVersionOrComponent(trailingSegments)) {
            return LegacyProjectUrlComponentsExtractor.error(ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return Either.right((Object)new LegacyBrowseProjectUrlComponents(contextPath, key, this.extractSelectedTabFrom(urlParameters), trailingSegments, this.extractQueryStringParams(urlParameters)));
    }

    private Map<String, String[]> extractQueryStringParams(Map<String, String[]> urlParameters) {
        HashMap queryStringParameters = Maps.newHashMap(urlParameters);
        queryStringParameters.remove("id");
        queryStringParameters.remove(SELECTED_TAB_PARAM);
        return queryStringParameters;
    }

    private static boolean isLegacyBrowseActionRequest(String path) {
        return StringUtils.equalsIgnoreCase((CharSequence)path, (CharSequence)"/secure/BrowseProjectTabs.jspa") || StringUtils.equalsIgnoreCase((CharSequence)path, (CharSequence)"/secure/BrowseProject.jspa") || StringUtils.equalsIgnoreCase((CharSequence)path, (CharSequence)"/browse/");
    }

    private static Either<ErrorCollection, LegacyBrowseProjectUrlComponents> error(ErrorCollection.Reason reason) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addReason(reason);
        return ServiceResult.error((ErrorCollection)errorCollection);
    }

    private Option<String> extractSelectedTabFrom(Map<String, String[]> parameters) {
        if (parameters.get(SELECTED_TAB_PARAM) == null || parameters.get(SELECTED_TAB_PARAM).length < 1) {
            return Option.none();
        }
        return Option.some((Object)parameters.get(SELECTED_TAB_PARAM)[0]);
    }

    private static boolean isVersionOrComponent(List<String> segments) {
        String firstSegment = (String)Iterables.getFirst(segments, (Object)"");
        return StringUtils.equalsIgnoreCase((CharSequence)"fixforversion", (CharSequence)firstSegment) || StringUtils.equalsIgnoreCase((CharSequence)"component", (CharSequence)firstSegment);
    }

    private Option<String> extractProjectKeyFromUserCurrentProject() {
        Project currentProject = this.userProjectHistoryManager.getCurrentProject(10, this.jiraAuthenticationContext.getLoggedInUser());
        return Option.option((Object)(currentProject == null ? null : currentProject.getKey()));
    }

    private Option<String> extractProjectKeyGivenProjectId(long projectId) {
        Either<ErrorCollection, Project> projectResult = this.projectService.getProject(projectId);
        if (projectResult.isLeft()) {
            return Option.none();
        }
        return Option.some((Object)((Project)projectResult.right().get()).getKey());
    }
}

