/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy;

import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.legacy.LegacyBrowseProjectUrlComponents;
import com.atlassian.jira.projects.legacy.LegacyBrowseProjectUrlTransformer;
import com.atlassian.jira.projects.legacy.LegacyProjectTabToSidebarItemTransformer;
import com.atlassian.jira.projects.web.redirect.IssueNavigatorUrlGenerator;
import com.atlassian.jira.util.UrlBuilder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultLegacyUrlTransformer
implements LegacyBrowseProjectUrlTransformer {
    private final LegacyProjectTabToSidebarItemTransformer projectTabToSidebarItem;
    private final IssueNavigatorUrlGenerator issueNavUrlGenerator;

    @Autowired
    public DefaultLegacyUrlTransformer(LegacyProjectTabToSidebarItemTransformer projectTabToSidebarItem, IssueNavigatorUrlGenerator issueNavUrlGenerator) {
        this.projectTabToSidebarItem = projectTabToSidebarItem;
        this.issueNavUrlGenerator = issueNavUrlGenerator;
    }

    public Option<String> getTransformedUrl(LegacyBrowseProjectUrlComponents legacyUrlComponents) {
        if (this.isGoingToAllIssues((Option<String>)legacyUrlComponents.getSelectedTab())) {
            return this.getAllIssuesUrl(legacyUrlComponents);
        }
        return this.getProjectsUrl(legacyUrlComponents);
    }

    private boolean isGoingToAllIssues(Option<String> selectedProjectTab) {
        return selectedProjectTab.isDefined() && StringUtils.endsWith((CharSequence)((CharSequence)selectedProjectTab.get()), (CharSequence)"issues-panel");
    }

    private Option<String> getAllIssuesUrl(LegacyBrowseProjectUrlComponents legacyUrlComponents) {
        return Option.some((Object)this.issueNavUrlGenerator.generateAllIssuesInProjectUrl(legacyUrlComponents.getContextPath(), legacyUrlComponents.getProjectKey()));
    }

    private Option<String> getProjectsUrl(LegacyBrowseProjectUrlComponents urlComponents) {
        UrlBuilder url = new UrlBuilder(urlComponents.getContextPath(), false);
        url.addPath("projects").addPath(urlComponents.getProjectKey());
        for (String segment : urlComponents.getTrailingSegments()) {
            url.addPath(segment);
        }
        Option<String> sidebarItem = this.selectedSidebarItemItemFrom((Option<String>)urlComponents.getSelectedTab());
        if (sidebarItem.isDefined()) {
            url.addParameter("selectedItem", (String)sidebarItem.get());
        }
        for (Map.Entry parameter : urlComponents.getQueryStringParameters().entrySet()) {
            for (String parameterValue : (String[])parameter.getValue()) {
                url.addParameter((String)parameter.getKey(), parameterValue);
            }
        }
        return Option.some((Object)url.asUrlString());
    }

    private Option<String> selectedSidebarItemItemFrom(Option<String> selectedProjectTab) {
        return this.projectTabToSidebarItem.transformToSidebarItem((String)selectedProjectTab.getOrNull());
    }
}

