/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.badges;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.badges.ReleaseNavigationItemBadgeService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="project/{projectKey}/badges")
public class SidebarBadgesResource {
    private final ReleaseNavigationItemBadgeService releaseNavItemBadgeService;
    private final ProjectService projectService;

    public SidebarBadgesResource(ReleaseNavigationItemBadgeService releaseNavItemBadgeService, ProjectService projectService) {
        this.releaseNavItemBadgeService = releaseNavItemBadgeService;
        this.projectService = projectService;
    }

    @PUT
    @AnonymousAllowed
    public Response incrementViewedCountForAllBadges(@PathParam(value="projectKey") String projectKey) {
        Either<ErrorCollection, Project> project = this.projectService.getProject(projectKey);
        if (project.isLeft()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.releaseNavItemBadgeService.incrementBadgeViewedCount((Project)project.right().get());
        return Response.ok(this.prepareResponse()).build();
    }

    private Map<String, List<String>> prepareResponse() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put("badgesToRemove", new ArrayList());
        if (!this.releaseNavItemBadgeService.canBadgeBeDisplayed()) {
            ((List)result.get("badgesToRemove")).add("com.atlassian.jira.jira-projects-plugin:release-page");
        }
        return result;
    }
}

