/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.badges;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.badges.SidebarBadgesService;
import com.atlassian.jira.projects.page.release.VersionsDefinedAndVisibleCondition;
import com.atlassian.jira.projects.sidebar.BeforeSidebarRenderedEvent;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleaseNavigationItemBadgeService {
    static final String RELEASE_LINK_ID = "com.atlassian.jira.jira-projects-plugin:release-page";
    private final SidebarBadgesService badgesService;
    private final VersionsDefinedAndVisibleCondition projectHasVersionsConditon;

    @Autowired
    public ReleaseNavigationItemBadgeService(SidebarBadgesService badgesService, VersionsDefinedAndVisibleCondition projectHasVersionsCondition) {
        this.badgesService = badgesService;
        this.projectHasVersionsConditon = projectHasVersionsCondition;
    }

    public void sidebarAboutToBeRendered(@Nonnull BeforeSidebarRenderedEvent event) {
        if (this.releaseLinkWillBePresent(event.getProject())) {
            if (this.isReleaseNavigationItemSelected(event.getSelectedItemId())) {
                this.badgesService.discardBadgeFor(RELEASE_LINK_ID);
            } else {
                this.badgesService.incrementBadgeViewedCountFor(RELEASE_LINK_ID);
            }
        }
    }

    public void incrementBadgeViewedCount(@Nonnull Project browsedProject) {
        if (this.releaseLinkWillBePresent(browsedProject)) {
            this.badgesService.incrementBadgeViewedCountFor(RELEASE_LINK_ID);
        }
    }

    public boolean canBadgeBeDisplayed() {
        return this.badgesService.canDisplayBadgeFor(RELEASE_LINK_ID);
    }

    private boolean isReleaseNavigationItemSelected(String selectedItemId) {
        return RELEASE_LINK_ID.equals(selectedItemId);
    }

    private boolean releaseLinkWillBePresent(Project project) {
        ImmutableMap context = ImmutableMap.of((Object)"project", (Object)project);
        return this.projectHasVersionsConditon.shouldDisplay((Map<String, Object>)context);
    }
}

