/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.web.admin;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.seraph.util.RedirectUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@WebSudoRequired
public class ViewGlobalCollectors
extends JiraWebActionSupport {
    private final CollectorService collectorService;
    private Map<Long, List<Collector>> projectCollectors;
    private Map<Long, List<Collector>> leftColumn = new LinkedHashMap<Long, List<Collector>>();
    private Map<Long, List<Collector>> rightColumn = new LinkedHashMap<Long, List<Collector>>();

    public ViewGlobalCollectors(CollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public String doDefault() throws Exception {
        if (this.getLoggedInUser() == null) {
            HttpServletRequest request = ExecutingHttpRequest.get();
            return this.forceRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
        ServiceOutcome<Map<Long, List<Collector>>> result = this.collectorService.getCollectorsPerProject(this.getLoggedInUser());
        this.projectCollectors = (Map)result.getReturnedValue();
        int count = 0;
        for (Map.Entry<Long, List<Collector>> entry : this.projectCollectors.entrySet()) {
            if (count % 2 == 0) {
                this.leftColumn.put(entry.getKey(), entry.getValue());
            } else {
                this.rightColumn.put(entry.getKey(), entry.getValue());
            }
            ++count;
        }
        return "success";
    }

    public Map<Long, List<Collector>> getProjectCollectors() {
        return this.projectCollectors;
    }

    public Map<Long, List<Collector>> getLeftColumn() {
        return this.leftColumn;
    }

    public Map<Long, List<Collector>> getRightColumn() {
        return this.rightColumn;
    }

    public Project getProject(Long projectId) {
        return this.getProjectManager().getProjectObj(projectId);
    }
}

