/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.web.admin;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.view.GadgetViewFactory;
import com.atlassian.gadgets.view.ModuleId;
import com.atlassian.gadgets.view.View;
import com.atlassian.gadgets.view.ViewType;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorActivityHelper;
import com.atlassian.jira.collector.plugin.components.CollectorService;
import com.atlassian.jira.collector.plugin.components.ScriptletRenderer;
import com.atlassian.jira.collector.plugin.components.Trigger;
import com.atlassian.jira.collector.plugin.web.admin.AbstractProjectAdminAction;
import com.atlassian.jira.collector.plugin.web.admin.ContainingScriptlets;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ViewCollector
extends AbstractProjectAdminAction
implements ContainingScriptlets {
    private static final int DAYS_PAST = 30;
    public static final String GADGET_URL = "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:filter-results-gadget/gadgets/filter-results-gadget.xml";
    private static final String PREF_FILTER_ID = "filterId";
    private static final String PREF_IS_POPUP = "isPopup";
    private static final String PREF_IS_CONFIGURED = "isConfigured";
    private static final String JQL_PREFIX = "jql-";
    private static final String PREF_NUM = "num";
    private static final String PREF_COL_NAMES = "columnNames";
    private static final String PREF_REFRESH = "refresh";
    public static final int ISSUES_IN_TABLE = 7;
    private final CollectorService collectorService;
    private final ConstantsManager constantsManager;
    private final UserFormats userFormats;
    private final BuildUtilsInfo buildUtilsInfo;
    private final DarkFeatureManager darkFeatureManager;
    private final CollectorActivityHelper collectorActivityHelper;
    private final GadgetViewFactory gadgetViewFactory;
    private final GadgetRequestContextFactory gadgetRequestContextFactory;
    private final ScriptletRenderer scriptletRenderer;
    private String collectorId;
    private Map<String, List<Integer>> collectorActivty = new HashMap<String, List<Integer>>();
    private Collector collector;
    private String canonicalBaseUrl;
    private List<Issue> recentIssues;

    public ViewCollector(CollectorService collectorService, ConstantsManager constantsManager, CollectorActivityHelper collectorActivityHelper, GadgetViewFactory gadgetViewFactory, GadgetRequestContextFactory gadgetRequestContextFactory, ScriptletRenderer scriptletRenderer, VelocityRequestContextFactory velocityRequestContextFactory, UserFormats userFormats, BuildUtilsInfo buildUtilsInfo, DarkFeatureManager darkFeatureManager) {
        this.collectorService = collectorService;
        this.constantsManager = constantsManager;
        this.collectorActivityHelper = collectorActivityHelper;
        this.gadgetViewFactory = gadgetViewFactory;
        this.gadgetRequestContextFactory = gadgetRequestContextFactory;
        this.scriptletRenderer = scriptletRenderer;
        this.userFormats = userFormats;
        this.buildUtilsInfo = buildUtilsInfo;
        this.darkFeatureManager = darkFeatureManager;
        this.canonicalBaseUrl = velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }

    public String doDefault() throws Exception {
        if (this.getLoggedInUser() == null) {
            HttpServletRequest request = ExecutingHttpRequest.get();
            return this.forceRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
        ServiceOutcome<Collector> result = this.collectorService.getCollector(this.collectorId);
        if (!result.isValid() || result.getReturnedValue() == null) {
            this.getErrorMessages().addAll(result.getErrorCollection().getErrorMessages());
            this.getErrors().putAll(result.getErrorCollection().getErrors());
            return "error";
        }
        if (!this.collectorService.hasViewPermission(this.getLoggedInUser(), (Collector)result.getReturnedValue())) {
            this.addErrorMessageByKeyIfAbsent("collector.plugin.admin.error.view.no.permission");
            return "error";
        }
        this.collector = (Collector)result.getReturnedValue();
        this.recentIssues = this.collectorActivityHelper.getCollectorIssues(this.getLoggedInUser(), this.collector, 7);
        return "success";
    }

    public Collector getCollector() {
        return this.collector;
    }

    public IssueType getIssueType(Long issueTypeId) {
        return this.constantsManager.getIssueTypeObject(issueTypeId.toString());
    }

    public String getFormattedUserAsHtml(String username) {
        return this.userFormats.forType("profileLinkActionHeader").format(username, "collector-reporter");
    }

    public List<String> getActiviyDates(Collector collector) {
        DateTime dateTime = new DateTime();
        ArrayList<String> ret = new ArrayList<String>();
        DateTimeFormatter format = DateTimeFormat.forPattern((String)"d MMM");
        for (int i = 29; i >= 0; --i) {
            DateTime pastDateTime = dateTime.dayOfYear().addToCopy(-i);
            ret.add(format.print((ReadableInstant)pastDateTime));
        }
        return ret;
    }

    public List<Integer> getActivityForCollector(Collector collector) {
        if (!this.collectorActivty.containsKey(collector.getId())) {
            this.collectorActivty.put(collector.getId(), this.collectorActivityHelper.getIssuesCreatedPerDay(this.getLoggedInUser(), collector, 30));
        }
        return this.collectorActivty.get(collector.getId());
    }

    public String getActivityUrl() {
        return this.collectorActivityHelper.getIssueNavigatorUrl(this.getLoggedInUser(), this.collector);
    }

    @Override
    public String getCollectorId() {
        return this.collectorId;
    }

    @Override
    public String getBootstrapLink() {
        return this.scriptletRenderer.renderCleanBootstrapLink();
    }

    @Override
    public String getConfigurationSource() {
        return this.scriptletRenderer.renderConfigurationBootstrap(this.collector);
    }

    public void setCollectorId(String collectorId) {
        this.collectorId = collectorId;
    }

    @Override
    public String getScriptSource() {
        return this.scriptletRenderer.render(this.collector);
    }

    @Override
    public String getScriptSourceJavascript() {
        return this.scriptletRenderer.renderJavascript(this.collector);
    }

    public boolean isCustomTrigger() {
        return this.collector.getTrigger().getPosition().equals((Object)Trigger.Position.CUSTOM);
    }

    public boolean isCustomTriggerFunction() {
        return StringUtils.isNotBlank((String)this.collector.getTrigger().getCustomFunction());
    }

    public boolean isDisplayJavascriptFieldAccessWarning() {
        return StringUtils.equals((String)"custom", (String)this.collector.getTemplate().getId());
    }

    public String getFilterGadgetHtml() {
        MapBuilder prefsBuilder = MapBuilder.newBuilder();
        prefsBuilder.add((Object)PREF_IS_POPUP, (Object)Boolean.FALSE.toString());
        prefsBuilder.add((Object)PREF_IS_CONFIGURED, (Object)Boolean.TRUE.toString());
        prefsBuilder.add((Object)PREF_NUM, (Object)"7");
        prefsBuilder.add((Object)PREF_COL_NAMES, (Object)"--Default--");
        prefsBuilder.add((Object)PREF_REFRESH, (Object)"false");
        prefsBuilder.add((Object)PREF_FILTER_ID, (Object)(JQL_PREFIX + this.collectorActivityHelper.getJql(this.getLoggedInUser(), this.collector)));
        Map prefs = prefsBuilder.toMutableMap();
        GadgetState gadget = GadgetState.gadget((GadgetId)GadgetId.valueOf((String)"1")).specUri(URI.create(GADGET_URL)).userPrefs(prefs).build();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter gadgetWriter = new OutputStreamWriter(baos);
            GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(this.request);
            View readOnlyDefaultView = new View.Builder().viewType(ViewType.DEFAULT).addViewParam("enableReload", "false").writable(false).build();
            this.gadgetViewFactory.createGadgetView(gadget, ModuleId.valueOf((long)1L), readOnlyDefaultView, requestContext).writeTo((Writer)gadgetWriter);
            ((Writer)gadgetWriter).flush();
            return baos.toString();
        }
        catch (IOException e) {
            this.log.error((Object)"Error rendering gadget 'rest/gadgets/1.0/g/com.atlassian.jira.gadgets:filter-results-gadget/gadgets/filter-results-gadget.xml'", (Throwable)e);
            return "";
        }
    }

    public String getCanonicalBaseUrl() {
        return this.canonicalBaseUrl;
    }

    public List<Issue> getRecentIssues() {
        return this.recentIssues;
    }

    public int getIssuesCount() {
        return this.collectorActivityHelper.getAllCollectorIssuesCount(this.getLoggedInUser(), this.collector);
    }

    @Override
    public boolean isBootStrapModeEnabled() {
        return this.darkFeatureManager.isFeatureEnabledForCurrentUser("issue.collector.bootstrap.mode");
    }

    public boolean isUseNewPanelHeader() {
        return this.buildUtilsInfo.getApplicationBuildNumber() >= 800;
    }
}

