/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.web.admin;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorService;
import com.atlassian.jira.collector.plugin.components.ScriptletRenderer;
import com.atlassian.jira.collector.plugin.web.admin.AbstractProjectAdminAction;
import com.atlassian.jira.collector.plugin.web.admin.ContainingScriptlets;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class InsertCollectorHelp
extends AbstractProjectAdminAction
implements ContainingScriptlets {
    private String collectorId;
    private Collector collector;
    private final CollectorService collectorService;
    private final ScriptletRenderer scriptletRenderer;
    private final DarkFeatureManager darkFeatureManager;

    public InsertCollectorHelp(CollectorService collectorService, ScriptletRenderer scriptletRenderer, DarkFeatureManager darkFeatureManager) {
        this.collectorService = collectorService;
        this.scriptletRenderer = scriptletRenderer;
        this.darkFeatureManager = darkFeatureManager;
    }

    public String doDefault() throws Exception {
        if (this.getLoggedInUser() == null) {
            HttpServletRequest request = ExecutingHttpRequest.get();
            return this.forceRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
        ServiceOutcome<Collector> result = this.collectorService.getCollector(this.collectorId);
        if (result.isValid() && result.getReturnedValue() != null) {
            this.collector = (Collector)result.getReturnedValue();
            return "success";
        }
        this.addErrorMessage("Collector with id " + this.collectorId + " not found!");
        return "error";
    }

    @Override
    public String getCollectorId() {
        return this.collectorId;
    }

    @Override
    public String getBootstrapLink() {
        return this.scriptletRenderer.renderCleanBootstrapLink();
    }

    @Override
    public String getConfigurationSource() {
        return this.scriptletRenderer.renderConfigurationBootstrap(this.collector);
    }

    public void setCollectorId(String collectorId) {
        this.collectorId = collectorId;
    }

    public boolean isDisplayJavascriptFieldAccessWarning() {
        Collector collector = (Collector)this.collectorService.getCollector(this.collectorId).getReturnedValue();
        return collector == null || StringUtils.equals((String)"custom", (String)collector.getTemplate().getId());
    }

    @Override
    public boolean isBootStrapModeEnabled() {
        return this.darkFeatureManager.isFeatureEnabledForCurrentUser("issue.collector.bootstrap.mode");
    }

    @Override
    @HtmlSafe
    public String getScriptSource() {
        return this.scriptletRenderer.render(this.collector);
    }

    @Override
    @HtmlSafe
    public String getScriptSourceJavascript() {
        return this.scriptletRenderer.renderJavascript(this.collector);
    }

    public Collection<String> getErrorMessages() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Map<String, String> getErrors() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

