/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.transformer;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.gzipfilter.GzipFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;

public class WebResourceFixererUpper
extends AbstractHttpFilter {
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        GenericResponseWrapper wrapper = new GenericResponseWrapper(response);
        request.setAttribute(GzipFilter.class.getName() + "_already_filtered", (Object)Boolean.TRUE);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
        String encoding = response.getCharacterEncoding();
        String resource = new String(wrapper.getData(), encoding);
        ServletOutputStream out = response.getOutputStream();
        byte[] output = resource.replaceAll("window\\.top", "window").getBytes(encoding);
        out.write(output);
        out.flush();
    }

    static class FilterServletOutputStream
    extends ServletOutputStream {
        private OutputStream stream;

        public FilterServletOutputStream(OutputStream output) {
            this.stream = output;
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }
    }

    static class GenericResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayOutputStream output = new ByteArrayOutputStream();

        public GenericResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public byte[] getData() {
            return this.output.toByteArray();
        }

        public ServletOutputStream getOutputStream() {
            return new FilterServletOutputStream(this.output);
        }

        public void setContentLength(int length) {
        }

        public void setHeader(String name, String value) {
            if (StringUtils.equalsIgnoreCase((String)"content-length", (String)name)) {
                return;
            }
            super.setHeader(name, value);
        }

        public PrintWriter getWriter() throws UnsupportedEncodingException {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding());
            return new PrintWriter((Writer)out, true);
        }
    }
}

