/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.transformer;

import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Element;

public class ScriptletTransformer
implements WebResourceTransformer {
    public DownloadableResource transform(Element element, ResourceLocation resourceLocation, String s, DownloadableResource downloadableResource) {
        return new JavascriptSubstitutionDownloadableResource(downloadableResource);
    }

    static class JavascriptSubstitutionDownloadableResource
    extends CharSequenceDownloadableResource {
        private static final Pattern VARIABLE_PATTERN = Pattern.compile("@([a-zA-Z][a-zA-Z0-9_]*)");
        private final Map<String, String> params = new HashMap<String, String>();

        public JavascriptSubstitutionDownloadableResource(DownloadableResource originalResource) {
            super(originalResource);
            this.params.put("baseUrl", JiraUrl.constructBaseUrl((HttpServletRequest)ExecutingHttpRequest.get()));
            this.params.put("contextPath", ExecutingHttpRequest.get().getContextPath());
        }

        protected String transform(CharSequence input) {
            Matcher matcher = VARIABLE_PATTERN.matcher(input);
            int start = 0;
            StringBuilder out = null;
            while (matcher.find()) {
                if (out == null) {
                    out = new StringBuilder();
                }
                out.append(input.subSequence(start, matcher.start()));
                String token = matcher.group(1);
                String subst = this.params.get(token);
                if (subst != null) {
                    out.append(subst);
                } else {
                    out.append(matcher.group());
                }
                start = matcher.end();
            }
            if (out == null) {
                return input.toString();
            }
            out.append(input.subSequence(start, input.length()));
            return out.toString();
        }
    }
}

