/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.collector.plugin.components.Collector;
import com.atlassian.jira.collector.plugin.components.CollectorFieldValidator;
import com.atlassian.jira.collector.plugin.components.CollectorService;
import com.atlassian.jira.collector.plugin.components.CreateIssueValidator;
import com.atlassian.jira.collector.plugin.components.ErrorLog;
import com.atlassian.jira.collector.plugin.components.IssueCollectorEventDispatcher;
import com.atlassian.jira.collector.plugin.components.Template;
import com.atlassian.jira.collector.plugin.components.TemplateStore;
import com.atlassian.jira.collector.plugin.rest.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.config.Configuration;

@Path(value="template")
@Consumes(value={"application/json"})
@Produces(value={"text/html"})
@AnonymousAllowed
public class TemplateResource {
    private static final Logger log = Logger.getLogger(TemplateResource.class);
    public static final String CUSTOM_TEMPLATE_ID = "custom";
    private static final Pattern URL_PATTERN = Pattern.compile("((https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]*)", 2);
    private static final String RESP_PREFIX = "<html><body><textarea>";
    private static final String RESP_POSTFIX = "</textarea></body></html>";
    private static final String ATTACHMENT_ERROR = "\"attachment_error\": \"One or more temporary attachments failed to convert\"";
    private static final int MAX_SUMMARY_LENGTH = 50;
    private final CollectorService collectorService;
    private final JiraAuthenticationContext authenticationContext;
    private final TemplateRenderer templateRenderer;
    private final WebResourceAssemblerFactory webResourceAssemblerFactory;
    private final WebResourceIntegration webResourceIntegration;
    private final UserManager userManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final TemplateStore templateStore;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final AttachmentManager attachmentManager;
    private final XsrfTokenGenerator xsrfTokenGenerator;
    private final ErrorLog errorLog;
    private final RendererManager rendererManager;
    private final ApplicationProperties applicationProperties;
    private final IssueFactory issueFactory;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final CollectorFieldValidator collectorFieldValidator;
    private final CreateIssueValidator createIssueValidator;
    @Context
    private HttpServletRequest request;
    private final IssueCollectorEventDispatcher eventDispatcher;
    private final UserSearchService userSearchService;

    public TemplateResource(CollectorService collectorService, JiraAuthenticationContext authenticationContext, TemplateRenderer templateRenderer, WebResourceAssemblerFactory webResourceAssemblerFactory, WebResourceIntegration webResourceIntegration, UserManager userManager, VelocityRequestContextFactory velocityRequestContextFactory, TemplateStore templateStore, PermissionManager permissionManager, ProjectManager projectManager, AttachmentManager attachmentManager, XsrfTokenGenerator xsrfTokenGenerator, ErrorLog errorLog, RendererManager rendererManager, ApplicationProperties applicationProperties, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, CollectorFieldValidator collectorFieldValidator, IssueCollectorEventDispatcher eventDispatcher, UserSearchService userSearchService, CreateIssueValidator createIssueValidator) {
        this.collectorService = collectorService;
        this.authenticationContext = authenticationContext;
        this.templateRenderer = templateRenderer;
        this.webResourceAssemblerFactory = webResourceAssemblerFactory;
        this.webResourceIntegration = webResourceIntegration;
        this.userManager = userManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.templateStore = templateStore;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.attachmentManager = attachmentManager;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
        this.errorLog = errorLog;
        this.rendererManager = rendererManager;
        this.applicationProperties = applicationProperties;
        this.issueFactory = issueFactory;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.collectorFieldValidator = collectorFieldValidator;
        this.eventDispatcher = eventDispatcher;
        this.userSearchService = userSearchService;
        this.createIssueValidator = createIssueValidator;
    }

    @GET
    @Path(value="{templateId}")
    public Response renderTemplate(@PathParam(value="templateId") String templateId, @QueryParam(value="preview") Boolean isPreview) {
        Template template = this.templateStore.getTemplate(templateId);
        if (template == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("showContactForm", true);
        context.put("recordWebInfo", true);
        if (CUSTOM_TEMPLATE_ID.equals(templateId)) {
            context.put("contactFormEditable", true);
        }
        context.put("preview", isPreview);
        context.put("attachmentsEnabled", this.applicationProperties.getOption("jira.option.allowattachments"));
        return Response.ok((Object)this.renderTemplate(template, context, false)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="form/{collectorId}")
    public Response getForm(@PathParam(value="collectorId") String collectorId, @QueryParam(value="preview") Boolean isPreview) {
        ServiceOutcome<Collector> result = this.collectorService.getCollector(collectorId);
        Collector collector = (Collector)result.getReturnedValue();
        if (collector == null || !collector.isEnabled()) {
            this.reportCollectorError(collector, collectorId, null, null, null, new ErrorCollection());
            return this.createErrorResponse(collector == null ? "collector.plugin.collector.not.found" : "collector.plugin.collector.disabled.msg");
        }
        TemporaryAttachmentsMonitorLocator.getAttachmentsMonitor(this.request, collector.getId()).clearEntriesForIssue(Long.valueOf(-1L));
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("collector", collector);
        boolean showContactForm = !this.hasCreateIssuePermission(collector, this.authenticationContext.getLoggedInUser());
        context.put("preview", isPreview);
        context.put("showContactForm", showContactForm);
        context.put("recordWebInfo", collector.isRecordWebInfo());
        if (StringUtils.isNotBlank((String)collector.getCustomMessage())) {
            context.put("showCustomMessage", true);
            context.put("customMessageHtml", this.rendererManager.getRenderedContent("atlassian-wiki-renderer", collector.getCustomMessage(), null));
        }
        if (collector.getTemplate().getId().equals(CUSTOM_TEMPLATE_ID)) {
            context.put("fields", new JSONArray(collector.getCustomTemplateFields()).toString());
            context.put("customLabels", collector.getCustomTemplateLabels());
            context.put("issueType", collector.getIssueTypeId());
            context.put("projectKey", this.projectManager.getProjectObj(collector.getProjectId()).getKey());
            context.put("atl_token", this.xsrfTokenGenerator.generateToken());
        }
        if (!showContactForm) {
            context.put("user", this.authenticationContext.getLoggedInUser());
        }
        context.put("attachmentsEnabled", this.applicationProperties.getOption("jira.option.allowattachments"));
        return Response.ok((Object)this.renderTemplate(collector.getTemplate(), context, true)).cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="fields/{collectorId}")
    @Produces(value={"application/json"})
    public Response getFields(@PathParam(value="collectorId") String collectorId) {
        ServiceOutcome<Collector> result = this.collectorService.getCollector(collectorId);
        Collector collector = (Collector)result.getReturnedValue();
        if (collector == null || !collector.isEnabled()) {
            this.reportCollectorError(collector, collectorId, null, null, null, new ErrorCollection());
            return this.createErrorResponse(collector == null ? "collector.plugin.collector.not.found" : "collector.plugin.collector.disabled.msg");
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("fields", collector.getCustomTemplateFields());
        context.put("labels", collector.getCustomTemplateLabels());
        return Response.ok((Object)new JSONObject(context).toString()).cacheControl(CacheControl.NO_CACHE).build();
    }

    @POST
    @Path(value="feedback/{collectorId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RequiresXsrfCheck
    public Response createFeedback(@PathParam(value="collectorId") String collectorId, @FormParam(value="description-good") String descriptionGood, @FormParam(value="description-bad") String descriptionBad, @FormParam(value="rating") String rating, @FormParam(value="fullname") String fullname, @FormParam(value="email") String email, @FormParam(value="webInfo") String webInfo, @FormParam(value="filetoconvert") List<Long> screenshotIds) {
        ServiceOutcome<Collector> outcome = this.collectorService.getCollector(collectorId);
        Collector collector = (Collector)outcome.getReturnedValue();
        if (collector == null || !collector.isEnabled()) {
            return this.reportCollectorError(collector, collectorId, fullname, email, webInfo, new ErrorCollection());
        }
        try {
            if (!StringUtils.isNotBlank((String)rating)) {
                return this.reportCollectorError(collector, collectorId, fullname, email, webInfo, new ErrorCollection());
            }
            Rating.valueOf(rating);
        }
        catch (IllegalArgumentException e) {
            return this.reportCollectorError(collector, collectorId, fullname, email, webInfo, new ErrorCollection());
        }
        Rating ratingValue = Rating.valueOf(rating);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("ratingValue", (Object)ratingValue);
        context.put("descriptionGoodHtml", descriptionGood);
        context.put("descriptionBadHtml", descriptionBad);
        String description = this.render("templates/feedback-wiki-markup.vm", context);
        IssueInputParametersImpl params = new IssueInputParametersImpl();
        params.setSummary(this.getSummary(descriptionGood));
        params.setDescription(description);
        return this.createIssue((IssueInputParameters)params, collector, fullname, email, webInfo, screenshotIds);
    }

    @POST
    @Path(value="form/{collectorId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RequiresXsrfCheck
    public Response createIssue(@PathParam(value="collectorId") String collectorId, @FormParam(value="description") String description, @FormParam(value="fullname") String fullname, @FormParam(value="email") String email, @FormParam(value="webInfo") String webInfo, @FormParam(value="filetoconvert") List<Long> screenshotIds) {
        ServiceOutcome<Collector> outcome;
        Collector collector;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("POST to form/%s", collectorId));
        }
        if ((collector = (Collector)(outcome = this.collectorService.getCollector(collectorId)).getReturnedValue()) == null || !collector.isEnabled()) {
            return this.reportCollectorError(collector, collectorId, fullname, email, webInfo, new ErrorCollection());
        }
        IssueInputParametersImpl params = new IssueInputParametersImpl();
        params.setSummary(this.getSummary(description));
        params.setDescription(description);
        return this.createIssue((IssueInputParameters)params, collector, fullname, email, webInfo, screenshotIds);
    }

    @POST
    @Path(value="custom/{collectorId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RequiresXsrfCheck
    public Response createCustomIssue(@PathParam(value="collectorId") String collectorId, @FormParam(value="fullname") String fullname, @FormParam(value="email") String email, @FormParam(value="webInfo") String webInfo, @FormParam(value="filetoconvert") List<Long> screenshotIds) {
        ServiceOutcome<Collector> outcome;
        Collector collector;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("POST to custom/%s", collectorId));
        }
        if ((collector = (Collector)(outcome = this.collectorService.getCollector(collectorId)).getReturnedValue()) == null || !collector.isEnabled()) {
            return this.reportCollectorError(collector, collectorId, fullname, email, webInfo, new ErrorCollection());
        }
        HashMap requestParams = new HashMap(this.request.getParameterMap());
        requestParams.remove("filetoconvert");
        IssueInputParametersImpl params = new IssueInputParametersImpl(requestParams);
        return this.createIssue((IssueInputParameters)params, collector, fullname, email, webInfo, screenshotIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response createIssue(IssueInputParameters params, Collector collector, String fullname, String email, String webInfo, List<Long> screenshotIds) {
        ApplicationUser remoteUser = this.authenticationContext.getLoggedInUser();
        ApplicationUser reporter = this.getReporter(collector, fullname, email);
        String env = params.getEnvironment() == null ? "" : params.getEnvironment();
        params.getActionParameters().put("labels", new String[]{"collector-" + collector.getId()});
        params.setEnvironment(env + "\n\n" + webInfo);
        params.setReporterId(reporter.getName());
        params.setAssigneeId("-1");
        params.setIssueTypeId(collector.getIssueTypeId().toString());
        params.setProjectId(collector.getProjectId());
        String description = params.getDescription();
        if (StringUtils.isNotBlank((String)fullname)) {
            String contactName = this.authenticationContext.getI18nHelper().getText("collector.plugin.template.contact.name", fullname);
            String string = description = StringUtils.isBlank((String)description) ? contactName : description + "\n\n" + contactName;
        }
        if (StringUtils.isNotBlank((String)email)) {
            String contactEmail = this.authenticationContext.getI18nHelper().getText("collector.plugin.template.contact.email", email);
            description = StringUtils.isBlank((String)description) ? contactEmail : description + "\n" + contactEmail;
        }
        params.setDescription(description);
        Map<String, String[]> requiredCustomFieldsValues = this.getValuesForRequiredCustomFieldsNotSetInForm(collector, params, reporter);
        for (String customFieldId : requiredCustomFieldsValues.keySet()) {
            params.addCustomFieldValue(customFieldId, requiredCustomFieldsValues.get(customFieldId));
        }
        if (log.isDebugEnabled()) {
            String oldUserName = null != remoteUser ? remoteUser.getName() : "NULL?!";
            String newUserName = null != reporter ? reporter.getName() : "NULL?!";
            log.debug((Object)String.format("Setting logged in user to <%s> (was <%s>)", newUserName, oldUserName));
        }
        this.authenticationContext.setLoggedInUser(reporter);
        try {
            Either<ErrorCollection, Issue> validationResult;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Validating create issue with params...");
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                Map things = params.getActionParameters();
                for (String key : things.keySet()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    sb.append(key).append("=").append(Iterables.toString(Lists.newArrayList((Object[])things.get(key))));
                }
                log.debug((Object)sb.toString());
            }
            if ((validationResult = this.createIssueValidator.createIssueIfValid(reporter, params)).isLeft()) {
                ErrorCollection errors = (ErrorCollection)validationResult.left().get();
                log.debug((Object)"Validation of create issue failed!");
                log.debug((Object)errors.toString());
                this.writeErrorToCollectorsLog(collector, collector.getId(), fullname, email, webInfo, errors, Response.Status.BAD_REQUEST);
                DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
                log.debug((Object)"Returning custom 200 response with validation result error collection");
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)(RESP_PREFIX + marshaller.marshal((Object)errors) + RESP_POSTFIX)).cacheControl(CacheControl.NO_CACHE).build();
                return response;
            }
            Issue issue = (Issue)validationResult.right().get();
            this.eventDispatcher.issueSubmitted(collector);
            boolean attachmentConversionSucceeded = true;
            TemporaryAttachmentsMonitor attachmentsMonitor = TemporaryAttachmentsMonitorLocator.getAttachmentsMonitor(this.request, collector.getId());
            Collection attachments = attachmentsMonitor.getByIssueId(Long.valueOf(-1L));
            if (!attachments.isEmpty()) {
                try {
                    this.attachmentManager.convertTemporaryAttachments(reporter, issue, screenshotIds, attachmentsMonitor);
                }
                catch (Throwable t) {
                    log.error((Object)"Generic Error attaching files", t);
                    attachmentConversionSucceeded = false;
                }
            }
            String feedbackLocation = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl() + "/browse/" + issue.getKey();
            if (this.permissionManager.hasPermission(10, issue, remoteUser)) {
                String jsonResponse = "{\"key\":\"" + issue.getKey() + "\", \"url\":\"" + feedbackLocation + "\"" + (attachmentConversionSucceeded ? "" : ", \"attachment_error\": \"One or more temporary attachments failed to convert\"") + "}";
                log.debug((Object)("Issue created via collector! The original remote user would be allowed to see the issue. Returning " + jsonResponse));
                Response response = Response.ok((Object)(RESP_PREFIX + jsonResponse + RESP_POSTFIX)).cacheControl(CacheControl.NO_CACHE).build();
                return response;
            }
            log.debug((Object)"Issue created via collector! Original remote user wouldn't be able to see issue.");
            Response response = Response.ok((Object)("<html><body><textarea>{" + (attachmentConversionSucceeded ? "" : ATTACHMENT_ERROR) + "}" + RESP_POSTFIX)).cacheControl(CacheControl.NO_CACHE).build();
            return response;
        }
        finally {
            this.authenticationContext.setLoggedInUser(remoteUser);
        }
    }

    private Map<String, String[]> getValuesForRequiredCustomFieldsNotSetInForm(Collector collector, IssueInputParameters params, ApplicationUser loggedUser) {
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectId(collector.getProjectId());
        issue.setIssueTypeId(collector.getIssueTypeId().toString());
        Project project = this.projectManager.getProjectObj(collector.getProjectId());
        FieldScreenRenderer fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(loggedUser, (Issue)issue, (IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, false);
        List fieldScreenRenderTabs = fieldScreenRenderer.getFieldScreenRenderTabs();
        Set<String> allowedCustomFieldIds = this.collectorFieldValidator.getAllowedCustomFieldIds(project, issue.getIssueTypeObject().getId());
        HashMap<String, String[]> defaultRequiredValues = Maps.newHashMap();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderTabs) {
            for (FieldScreenRenderLayoutItem fsrli : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                FieldLayoutItem field = fsrli.getFieldLayoutItem();
                String fieldId = field.getOrderableField().getId();
                String customFieldValidationId = fieldId.split(":")[0];
                if (!allowedCustomFieldIds.contains(customFieldValidationId) || !field.isRequired() || field.getOrderableField().getDefaultValue((Issue)issue) == null || params.getCustomFieldValue(fieldId) != null) continue;
                HashMap defaultValuesHolder = Maps.newHashMap();
                field.getOrderableField().populateDefaults(defaultValuesHolder, (Issue)issue);
                defaultRequiredValues.putAll(this.getRequiredCustomFieldsValues(fieldId, defaultValuesHolder));
            }
        }
        return defaultRequiredValues;
    }

    private Map<? extends String, ? extends String[]> getRequiredCustomFieldsValues(String fieldId, Map defaultValuesHolder) {
        HashMap<String, String[]> result = Maps.newHashMap();
        CustomFieldParams customFieldParams = (CustomFieldParams)defaultValuesHolder.get(fieldId);
        Map customFieldsParams = customFieldParams.getKeysAndValues();
        Collection defaultParamValues = customFieldParams.getValuesForNullKey();
        if (customFieldsParams.keySet().size() > 1) {
            for (Map.Entry entries : customFieldsParams.entrySet()) {
                if (entries.getKey() != null) {
                    String value = (String)((List)entries.getValue()).get(0);
                    String idPostfix = (String)entries.getKey();
                    result.put(fieldId + ":" + idPostfix, Iterables.toArray(ImmutableList.of(value), String.class));
                    continue;
                }
                result.put(fieldId, Iterables.toArray(defaultParamValues, String.class));
            }
        } else {
            result.put(fieldId, Iterables.toArray(defaultParamValues, String.class));
        }
        return result;
    }

    private Response reportCollectorError(Collector collector, String collectorId, String fullname, String email, String webInfo, ErrorCollection errors) {
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        if (collector == null) {
            status = Response.Status.NOT_FOUND;
        } else if (!collector.isEnabled()) {
            status = Response.Status.FORBIDDEN;
        }
        this.writeErrorToCollectorsLog(collector, collectorId, fullname, email, webInfo, errors, status);
        return Response.status((Response.Status)status).cacheControl(CacheControl.NO_CACHE).build();
    }

    private void writeErrorToCollectorsLog(Collector collector, String collectorId, String fullname, String email, String webInfo, ErrorCollection errors, Response.Status status) {
        Set<String> requiredFieldsNotPresent;
        String collectorName;
        Matcher matcher;
        String remoteAddress = this.getRemoteHost(this.request);
        if (StringUtils.isNotBlank((String)webInfo) && (matcher = URL_PATTERN.matcher(webInfo)).find()) {
            remoteAddress = matcher.group(0);
        }
        String realName = fullname;
        String realEmail = email;
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        if (StringUtils.isBlank((String)fullname) && loggedInUser != null) {
            realName = loggedInUser.getDisplayName();
            realEmail = loggedInUser.getEmailAddress();
        }
        Project project = this.projectManager.getProjectObj(collector != null ? collector.getProjectId() : this.collectorService.getArchivedProjectId(collectorId));
        String projectKey = project != null ? project.getKey() : "<unknown>";
        String string = collectorName = collector == null ? collectorId : collector.getName();
        if (!errors.getErrorMessages().isEmpty()) {
            log.error((Object)String.format("Detected errors in collector '%s' (id: %s, project %s): %s", collectorName, collectorId, projectKey, Iterables.toString(errors.getErrorMessages())));
        }
        if ((requiredFieldsNotPresent = this.getRequiredFieldsNotPresentInForm(collector, errors)).isEmpty()) {
            this.errorLog.logError(project, collectorName, realName, realEmail, remoteAddress, ErrorLog.ErrorType.from(status));
        } else {
            this.errorLog.logError(project, collectorName, realName, realEmail, remoteAddress, ErrorLog.ErrorType.MISSING_REQUIRED_FIELDS);
            String missingFields = Iterables.toString(requiredFieldsNotPresent);
            log.error((Object)String.format("Detected missing fields in collector '%s' (id: %s, project: %s): %s", collectorName, collectorId, projectKey, missingFields));
        }
    }

    private Set<String> getRequiredFieldsNotPresentInForm(Collector collector, ErrorCollection errors) {
        if (!errors.hasAnyErrors()) {
            return Collections.emptySet();
        }
        ImmutableSet<String> fieldsInError = ImmutableSet.copyOf(errors.getErrors().keySet());
        if (CUSTOM_TEMPLATE_ID.equals(collector.getTemplate().getId())) {
            List<String> allFields = collector.getCustomTemplateFields();
            HashSet<String> missingFields = new HashSet<String>();
            for (String fieldInError : fieldsInError) {
                if (allFields.contains(fieldInError)) continue;
                missingFields.add(fieldInError);
            }
            return ImmutableSet.copyOf(missingFields);
        }
        return fieldsInError;
    }

    private String getRemoteHost(HttpServletRequest request) {
        String[] hosts;
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && (hosts = xForwardedFor.split(",")).length > 0) {
            return hosts[0].trim();
        }
        return request.getRemoteHost();
    }

    private ApplicationUser getReporter(Collector collector, String fullname, String email) {
        ApplicationUser loggedInUser;
        if (log.isDebugEnabled()) {
            String collectorId = null != collector ? collector.getId() : "NULL?!";
            log.debug((Object)String.format("Finding reporter for collector %s, with fullname <%s> and email <%s>", collectorId, fullname, email));
        }
        if (this.hasCreateIssuePermission(collector, loggedInUser = this.authenticationContext.getLoggedInUser()) && StringUtils.isBlank((String)fullname) && StringUtils.isBlank((String)email)) {
            log.debug((Object)"Using logged in user as reporter");
            return loggedInUser;
        }
        if (StringUtils.isNotBlank((String)email) && collector.isUseCredentials()) {
            for (ApplicationUser user : this.userSearchService.findUsersByEmail(email)) {
                if (!this.hasCreateIssuePermission(collector, user)) continue;
                log.debug((Object)"Using user with matching email address");
                return user;
            }
        }
        log.debug((Object)"Using reporter configured on collector");
        return this.userManager.getUserObject(collector.getReporter());
    }

    private Response createErrorResponse(String messageKey) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", this.authenticationContext.getI18nHelper().getText(messageKey));
        context.put("webResourcesHtml", this.getWebresourceTags());
        this.render("templates/collector/disabled.vm", context);
        return Response.ok((Object)this.render("templates/collector/disabled.vm", context)).cacheControl(CacheControl.NO_CACHE).build();
    }

    private String renderTemplate(Template template, Map<String, Object> context, boolean includeResources) {
        context.put("webResourcesHtml", includeResources ? this.getWebresourceTags() : "");
        context.put("canocialBaseurl", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
        return this.render(template.getTemplatePath(), context);
    }

    private String getWebresourceTags() {
        StringWriter out = new StringWriter();
        WebResourceAssembler assembler = this.webResourceAssemblerFactory.create().build();
        assembler.resources().requireWebResource("jira.webresources:calendar").requireWebResource("jira.webresources:calendar-" + this.authenticationContext.getLocale().getLanguage()).requireWebResource("jira.webresources:calendar-localisation-moment").requireWebResource("com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:form-collector");
        assembler.assembled().drainIncludedResources().writeHtmlTags((Writer)out, UrlMode.RELATIVE);
        String prefixStatic = this.webResourceIntegration.getBaseUrl(com.atlassian.plugin.webresource.UrlMode.RELATIVE) + "/s/";
        String prefixCollector = prefixStatic + "collector-resource-";
        String[] lines = out.toString().split("\\r?\\n");
        StringBuilder rewrite = new StringBuilder();
        for (String line : lines) {
            if (line.contains("contextbatch/js/_super/batch.js") || line.contains("/superbatch/js/batch.js") || line.matches(".*jira\\.webresources\\:.*\\.js.*")) {
                rewrite.append(StringUtils.replaceOnce((String)line, (String)prefixStatic, (String)prefixCollector)).append("\n");
                continue;
            }
            rewrite.append(line).append("\n");
        }
        return rewrite.toString();
    }

    private String render(String templatePath, Map<String, Object> context) {
        StringWriter out = new StringWriter();
        try {
            context.putAll(JiraVelocityUtils.createVelocityParams((JiraAuthenticationContext)this.authenticationContext));
            context.put("maxAttachSize", Long.parseLong(Configuration.getString((String)"webwork.multipart.maxSize")));
            this.templateRenderer.render(templatePath, context, (Writer)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }

    private String getSummary(String description) {
        String summary = description.replaceAll("\n", " ").replaceAll("\r", " ");
        if (summary.length() > 50) {
            return summary.substring(0, 50) + "...";
        }
        return summary;
    }

    private boolean hasCreateIssuePermission(Collector collector, ApplicationUser user) {
        if (user == null) {
            return false;
        }
        if (!collector.isUseCredentials()) {
            return false;
        }
        Project projectObj = this.projectManager.getProjectObj(collector.getProjectId());
        return this.permissionManager.hasPermission(11, projectObj, user);
    }

    public static enum Rating {
        AWESOME("collector.plugin.template.awesome", ":D"),
        GOOD("collector.plugin.template.good", ":)"),
        MEH("collector.plugin.template.meh", ";)"),
        BAD("collector.plugin.template.bad", ":("),
        HORRIBLE("collector.plugin.template.horrible", "(n)");

        private final String i18nKey;
        private final String smiley;

        private Rating(String i18nKey, String smiley) {
            this.i18nKey = i18nKey;
            this.smiley = smiley;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }

        public String getSmiley() {
            return this.smiley;
        }
    }
}

