/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.collector.plugin.rest;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="project")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ProjectResource {
    public static final int DEFAULT_USERS_RETURNED = 50;
    public static final int MAX_USERS_RETURNED = 1000;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final UserPickerSearchService userPickerSearchService;
    private final EmailFormatter emailFormatter;
    private final JiraAuthenticationContext authContext;
    private final TimeZoneManager timeZoneManager;
    private final JiraBaseUrls jiraBaseUrls;

    public ProjectResource(PermissionManager permissionManager, ProjectManager projectManager, UserPickerSearchService userPickerSearchService, EmailFormatter emailFormatter, JiraAuthenticationContext authContext, TimeZoneManager timeZoneManager, JiraBaseUrls jiraBaseUrls) {
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.userPickerSearchService = userPickerSearchService;
        this.emailFormatter = emailFormatter;
        this.authContext = authContext;
        this.timeZoneManager = timeZoneManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @GET
    @Path(value="reporter/search")
    public Response getRepoterForProject(@QueryParam(value="username") String username, @QueryParam(value="projectKeys") String projectKey, @QueryParam(value="maxResults") Integer maxResults, @QueryParam(value="startAt") Integer startAt) {
        final Project project = this.projectManager.getProjectObjByKey(projectKey);
        List users = this.userPickerSearchService.findUsers(this.getContext(), username);
        ImmutableList<ApplicationUser> filteredUsers = ImmutableList.copyOf(Iterables.limit(Iterables.filter(users, new Predicate<ApplicationUser>(){

            @Override
            public boolean apply(ApplicationUser user) {
                return ProjectResource.this.permissionManager.hasPermission(11, project, user);
            }
        }), maxResults));
        return Response.ok(this.makeUserBeans(filteredUsers)).cacheControl(CacheControl.never()).build();
    }

    private List<ApplicationUser> limitUserSearch(Integer startAt, Integer maxResults, List<ApplicationUser> users) {
        int start = startAt != null ? Math.max(0, startAt) : 0;
        int end = (maxResults != null ? Math.min(1000, maxResults) : 50) + start;
        return users.subList(start, Math.min(users.size(), end));
    }

    JiraServiceContext getContext() {
        ApplicationUser user = this.authContext.getLoggedInUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return new JiraServiceContextImpl(user, (ErrorCollection)errorCollection);
    }

    private List<UserBean> makeUserBeans(Collection<ApplicationUser> users) {
        ArrayList<UserBean> beans = new ArrayList<UserBean>();
        for (ApplicationUser user : users) {
            UserBeanBuilder builder = new UserBeanBuilder(this.jiraBaseUrls).user(user);
            builder.loggedInUser(this.authContext.getLoggedInUser());
            builder.emailFormatter(this.emailFormatter);
            builder.timeZone(this.timeZoneManager.getLoggedInUserTimeZone());
            beans.add(builder.buildMid());
        }
        return beans;
    }
}

